/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.model;

import dk.eobjects.datacleaner.catalog.ColumnDictionary;
import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.gui.model.NamedConnection;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;

public class DatabaseDictionary
implements IDictionary {
    private static final long serialVersionUID = -997656251671163257L;
    private String _name;
    private String _namedConnectionName;
    private String _schemaName;
    private String _tableName;
    private String _columnName;
    private transient ColumnDictionary _columnDictionary;

    public DatabaseDictionary() {
    }

    public DatabaseDictionary(String name, String namedConnectionName, String schemaName, String tableName, String columnName) {
        this._name = name;
        this._namedConnectionName = namedConnectionName;
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._columnName = columnName;
    }

    public String getName() {
        return this._name;
    }

    public boolean[] isValid(String ... values) {
        try {
            return this.getColumnDictionary().isValid(values);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ColumnDictionary getColumnDictionary() throws SQLException, NullPointerException {
        if (this._columnDictionary == null) {
            DataContext dc = null;
            Collection<NamedConnection> namedConnections = GuiConfiguration.getBeansOfClass(NamedConnection.class);
            for (NamedConnection namedConnection : namedConnections) {
                if (!this._namedConnectionName.equals(namedConnection.getName())) continue;
                Connection connection = DriverManager.getConnection(namedConnection.getConnectionString(), namedConnection.getUsername(), namedConnection.getPassword());
                connection.setReadOnly(true);
                dc = new DataContext(connection, namedConnection.getCatalog());
            }
            Column column = dc.getSchemaByName(this._schemaName).getTableByName(this._tableName).getColumnByName(this._columnName);
            this._columnDictionary = new ColumnDictionary(this._name, dc, column);
        }
        return this._columnDictionary;
    }

    public String getNamedConnectionName() {
        return this._namedConnectionName;
    }

    public DatabaseDictionary setNamedConnectionName(String namedConnectionName) {
        this._namedConnectionName = namedConnectionName;
        return this;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public DatabaseDictionary setSchemaName(String schemaName) {
        this._schemaName = schemaName;
        return this;
    }

    public String getTableName() {
        return this._tableName;
    }

    public DatabaseDictionary setTableName(String tableName) {
        this._tableName = tableName;
        return this;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public DatabaseDictionary setColumnName(String columnName) {
        this._columnName = columnName;
        return this;
    }

    public DatabaseDictionary setName(String name) {
        this._name = name;
        return this;
    }
}

