/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.model;

import dk.eobjects.datacleaner.gui.model.DriverWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseDriver
implements Serializable {
    private static final long serialVersionUID = -3439901946268007295L;
    private static final Log _log = LogFactory.getLog(DatabaseDriver.class);
    private transient URLClassLoader _classLoader;
    private transient boolean _loaded = false;
    private transient Driver _driverInstance;
    private transient Driver _registeredDriver;
    private String _filename;
    private String _driverClass;
    private String _name;

    public DatabaseDriver() {
    }

    public DatabaseDriver(String name, String driverClass) {
        this._name = name;
        this._driverClass = driverClass;
    }

    public DatabaseDriver(File file, String driverClass) {
        this._filename = file.getAbsolutePath();
        this._driverClass = driverClass;
    }

    public DatabaseDriver loadDriver() throws FileNotFoundException, IllegalStateException, ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        if (this._driverClass == null) {
            throw new IllegalStateException("Class name must be set before loading driver");
        }
        if (this._filename == null) {
            this._driverInstance = this._registeredDriver = (Driver)Class.forName(this._driverClass).newInstance();
            DriverManager.registerDriver(this._registeredDriver);
            this._loaded = true;
        } else {
            try {
                URL url = new File(this._filename).toURL();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Using URL: " + url));
                }
                this._classLoader = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
                Class<?> loadedClass = Class.forName(this._driverClass, true, this._classLoader);
                _log.info((Object)("Loaded class: " + loadedClass.getName()));
                if (!Driver.class.isAssignableFrom(loadedClass)) {
                    throw new IllegalStateException("Class is not a Driver class: " + this._driverClass);
                }
                this._driverInstance = (Driver)loadedClass.newInstance();
                this._registeredDriver = new DriverWrapper(this._driverInstance);
                DriverManager.registerDriver(this._registeredDriver);
                this._loaded = true;
            }
            catch (MalformedURLException e) {
                throw new FileNotFoundException(this._filename);
            }
        }
        return this;
    }

    public void unloadDriver() {
        try {
            DriverManager.deregisterDriver(this._registeredDriver);
            this._registeredDriver = null;
            this._driverInstance = null;
            this._loaded = false;
        }
        catch (SQLException e) {
            _log.error((Object)e);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public String toString() {
        return "DatabaseDriver[name=" + this._name + ",filename=" + this._filename + ",driverClass=" + this._driverClass + "]";
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    public String getDriverClass() {
        return this._driverClass;
    }

    public void setDriverClass(String driverClass) {
        this._driverClass = driverClass;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }
}

