/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.metamodel.schema.Column;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidationRuleConfigurationPanel
extends JPanel
implements Closeable {
    protected final Log _log = LogFactory.getLog(this.getClass());
    private JTabbedPane _tabbedPane;
    private IValidationRuleDescriptor _descriptor;
    protected ColumnSelection _dataSelection;
    private JPanel _propertiesPanel;
    private Map<String, JTextField> _propertyFields = new HashMap<String, JTextField>();
    private final JTextField _nameField;

    public AbstractValidationRuleConfigurationPanel(JTabbedPane tabbedPane, IValidationRuleDescriptor descriptor, ColumnSelection dataSelection) {
        this._tabbedPane = tabbedPane;
        this._descriptor = descriptor;
        this._dataSelection = dataSelection;
        this.setLayout(new BoxLayout(this, 1));
        this._propertiesPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._propertiesPanel.setLayout(gridBagLayout);
        this._nameField = this.addPropertyField("Validation rule name");
        this.initNameField();
        if (this.autoGeneratePropertyFields()) {
            String[] propertyNames = this._descriptor.getPropertyNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String property = propertyNames[i];
                if (property == "Validation rule name") continue;
                this.addPropertyField(property);
            }
        }
        this._propertiesPanel.setBorder(new TitledBorder("Validation rule properties"));
        GuiHelper.addComponentAligned(this, this._propertiesPanel);
    }

    private void initNameField() {
        this._nameField.setText(this._descriptor.getDisplayName());
        final AbstractAction updateNameAction = new AbstractAction(){
            private static final long serialVersionUID = -4111273564944419469L;

            public void actionPerformed(ActionEvent e) {
                String name = AbstractValidationRuleConfigurationPanel.this._nameField.getText().trim();
                if (name.length() > 0) {
                    AbstractValidationRuleConfigurationPanel.this.updateTabTitle(name);
                }
            }
        };
        this._nameField.addActionListener(updateNameAction);
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                updateNameAction.actionPerformed(null);
            }
        };
        this._nameField.addKeyListener(keyListener);
    }

    public void updateTabTitle(String newTitle) {
        Component[] components = this._tabbedPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getComponent(0);
            }
            if (!(component instanceof AbstractValidationRuleConfigurationPanel) || component != this) continue;
            this._log.debug((Object)("Updating tab title to: " + newTitle));
            this._tabbedPane.setTitleAt(i, newTitle);
            break;
        }
    }

    protected abstract boolean autoGeneratePropertyFields();

    protected abstract void handleProperties(Map<String, String> var1);

    protected abstract Column[] getColumns(ColumnSelection var1);

    protected JTextField addPropertyField(String propertyName) {
        JTextField textField = new JTextField(30);
        this.addPropertyField(propertyName, textField);
        this._propertyFields.put(propertyName, textField);
        return textField;
    }

    protected void addPropertyField(String propertyName, Component component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.ipadx = 10;
        constraints.gridx = 0;
        constraints.anchor = 18;
        this._propertiesPanel.add((Component)new JLabel(propertyName), constraints);
        constraints.gridx = 1;
        this._propertiesPanel.add(component, constraints);
    }

    public ColumnSelection getDataSelection() {
        return this._dataSelection;
    }

    public ValidationRuleConfiguration getValidationRuleConfiguration() {
        ValidationRuleConfiguration configuration = new ValidationRuleConfiguration(this._descriptor);
        configuration.setColumns(this.getColumns(this._dataSelection));
        HashMap<String, String> properties = new HashMap<String, String>();
        Set<String> propertyKeys = this._propertyFields.keySet();
        for (String key : propertyKeys) {
            JTextField textField = this._propertyFields.get(key);
            String value = textField.getText();
            if (value == null || value.trim().length() <= 0) continue;
            properties.put(key, value);
        }
        this.handleProperties(properties);
        configuration.setValidationRuleProperties(properties);
        return configuration;
    }
}

