/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.AbstractValidationRuleConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.SubsetDataSelectionPanel;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.dictionary.DictionaryManager;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryValidationRuleConfigurationPanel
extends AbstractValidationRuleConfigurationPanel {
    private static final long serialVersionUID = 5363691191420388010L;
    private JComboBox _dictionaryDropDown;
    private SubsetDataSelectionPanel _subsetDataSelectionPanel;

    public DictionaryValidationRuleConfigurationPanel(JTabbedPane tabbedPane, final IValidationRuleDescriptor descriptor, ColumnSelection dataSelection) {
        super(tabbedPane, descriptor, dataSelection);
        this.createDictionaryDropDown();
        this.addPropertyField("Dictionary", this._dictionaryDropDown);
        this._subsetDataSelectionPanel = new SubsetDataSelectionPanel(dataSelection){
            private static final long serialVersionUID = -5227491742509256691L;

            protected boolean isSupported(ColumnType type) {
                return descriptor.isSupported(type);
            }
        };
        this.add(this._subsetDataSelectionPanel);
    }

    private void createDictionaryDropDown() {
        if (this._dictionaryDropDown == null) {
            this._dictionaryDropDown = new JComboBox();
        }
        IDictionary[] dictionaries = DictionaryManager.getDictionaries();
        for (int i = 0; i < dictionaries.length; ++i) {
            IDictionary d = dictionaries[i];
            String dictionaryName = d.getName();
            if (dictionaryName == null) continue;
            this._dictionaryDropDown.addItem(dictionaryName);
        }
    }

    @Override
    protected boolean autoGeneratePropertyFields() {
        return false;
    }

    @Override
    protected Column[] getColumns(ColumnSelection dataSelection) {
        List<Column> columns = this._subsetDataSelectionPanel.getSelectedColumns();
        return columns.toArray(new Column[columns.size()]);
    }

    @Override
    protected void handleProperties(Map<String, String> properties) {
        Object selectedItem = this._dictionaryDropDown.getSelectedItem();
        if (selectedItem != null) {
            properties.put("Dictionary name", selectedItem.toString());
        }
    }

    @Override
    public void close() throws IOException {
        this._log.debug((Object)"Closing dictionary validation rule configuration panel");
        this._subsetDataSelectionPanel.close();
    }

    public JComboBox getDictionaryDropDown() {
        return this._dictionaryDropDown;
    }
}

