/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.AbstractValidationRuleConfigurationPanel;
import dk.eobjects.datacleaner.gui.widgets.TableDataSelectionComboBox;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.metamodel.MetaModelHelper;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import dk.eobjects.thirdparty.textarea.JEditTextArea;
import dk.eobjects.thirdparty.textarea.tokermarkers.JavaScriptTokenMarker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptValidationRuleConfigurationPanel
extends AbstractValidationRuleConfigurationPanel {
    private static final long serialVersionUID = 3114999667016060473L;
    private JEditTextArea _expressionTextArea;
    private TableDataSelectionComboBox _tableComboBox;

    public JEditTextArea getExpressionTextArea() {
        return this._expressionTextArea;
    }

    public TableDataSelectionComboBox getTableComboBox() {
        return this._tableComboBox;
    }

    public JavascriptValidationRuleConfigurationPanel(JTabbedPane tabbedPane, IValidationRuleDescriptor descriptor, final ColumnSelection dataSelection) {
        super(tabbedPane, descriptor, dataSelection);
        this._tableComboBox = new TableDataSelectionComboBox(dataSelection);
        this._tableComboBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 3230354304700073366L;

            public void actionPerformed(ActionEvent e) {
                JavascriptValidationRuleConfigurationPanel.this.updateExampleScript(JavascriptValidationRuleConfigurationPanel.this._expressionTextArea, dataSelection);
            }
        });
        this.addPropertyField("Table", this._tableComboBox);
        JPanel expressionPanel = new JPanel(new BorderLayout());
        expressionPanel.setBorder(new TitledBorder("Expression"));
        this._expressionTextArea = new JEditTextArea();
        this._expressionTextArea.setTokenMarker(new JavaScriptTokenMarker());
        this.updateExampleScript(this._expressionTextArea, dataSelection);
        this._expressionTextArea.setBorder(new LineBorder(Color.GRAY));
        expressionPanel.add((Component)this._expressionTextArea, "Center");
        GuiHelper.addComponentAligned(this, expressionPanel);
    }

    private void updateExampleScript(JEditTextArea editorPane, ColumnSelection dataSelection) {
        String columnName = "COLUMN_NAME";
        List<Column> columns = dataSelection.getColumns();
        if (columns.size() > 0) {
            Table table = this._tableComboBox.getSelectedTable();
            for (Column column : columns) {
                if (table != column.getTable()) continue;
                columnName = column.getName();
                break;
            }
        }
        String prefix = "var value = values.get('";
        String suffix = "');\nvalue != null && value != '';";
        editorPane.setText("var value = values.get('" + columnName + "');\nvalue != null && value != '';");
        editorPane.setSelectionStart("var value = values.get('".length());
        editorPane.setSelectionEnd(("var value = values.get('" + columnName).length());
    }

    @Override
    protected boolean autoGeneratePropertyFields() {
        return false;
    }

    @Override
    protected void handleProperties(Map<String, String> properties) {
        properties.put("Javascript expression", this._expressionTextArea.getText());
    }

    @Override
    protected Column[] getColumns(ColumnSelection dataSelection) {
        Table selectedTable = this._tableComboBox.getSelectedTable();
        if (selectedTable != null) {
            Column[] tableColumns = MetaModelHelper.getTableColumns((Table)selectedTable, this._dataSelection.getColumns());
            return tableColumns;
        }
        return new Column[0];
    }

    @Override
    public void close() throws IOException {
        this._log.debug((Object)"Closing validation rule configuration panel");
        this._tableComboBox.close();
    }
}

