/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public class LookAndFeelSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 4806801697950234450L;
    private ButtonGroup _buttonGroup;

    public LookAndFeelSettingsPanel(GuiSettings settings) {
        super(new BorderLayout());
        Dimension d = new Dimension();
        d.width = 430;
        this.setSize(d);
        this.setPreferredSize(d);
        this.setLayout(new FlowLayout(0, 10, 10));
        JLabel header = new JLabel("Look and feel");
        header.setFont(GuiHelper.HEADER_FONT);
        d = new Dimension();
        d.width = 400;
        d.height = 20;
        header.setSize(d);
        header.setPreferredSize(d);
        this.add(header);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this._buttonGroup = new ButtonGroup();
        String selectedLookAndFeelClassName = settings.getLookAndFeelClassName();
        UIManager.LookAndFeelInfo[] lookAndFeelInfos = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfos.length; ++i) {
            String lafName = lookAndFeelInfos[i].getName();
            String lafClassName = lookAndFeelInfos[i].getClassName();
            JRadioButton radioButton = new JRadioButton(lafName);
            if (lafClassName.equals(selectedLookAndFeelClassName)) {
                radioButton.setSelected(true);
            }
            radioButton.setActionCommand(lookAndFeelInfos[i].getClassName());
            this._buttonGroup.add(radioButton);
            buttonPanel.add(radioButton);
        }
        this.add(buttonPanel);
    }

    public String getLookAndFeelClassName() {
        ButtonModel selection = this._buttonGroup.getSelection();
        String newLookAndFeelClassName = selection.getActionCommand();
        return newLookAndFeelClassName;
    }
}

