/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.SubsetDataSelectionPanel;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.ProfileConfiguration;
import dk.eobjects.metamodel.schema.ColumnType;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfileConfigurationPanel
extends JPanel
implements Closeable {
    private static final long serialVersionUID = -4407344030830571753L;
    private static Log _log = LogFactory.getLog(ProfileConfigurationPanel.class);
    private IProfileDescriptor _profileDescriptor;
    private JPanel _profilePropertiesPanel;
    private Map<String, JTextField> _propertyFields = new HashMap<String, JTextField>();
    private SubsetDataSelectionPanel _subsetDataSelectionPanel;

    public ProfileConfigurationPanel(final IProfileDescriptor profileDescriptor, ColumnSelection dataSelection) {
        this._profileDescriptor = profileDescriptor;
        _log.debug((Object)("Creating profile configuration panel for profile descriptor: " + this._profileDescriptor));
        this.setLayout(new BoxLayout(this, 1));
        this._subsetDataSelectionPanel = new SubsetDataSelectionPanel(dataSelection){
            private static final long serialVersionUID = 4878805667739164299L;

            protected boolean isSupported(ColumnType type) {
                return profileDescriptor.isSupported(type);
            }
        };
        GuiHelper.addComponentAligned(this, this._subsetDataSelectionPanel);
        this._profilePropertiesPanel = new JPanel();
        this._profilePropertiesPanel.setBorder(new TitledBorder("Profile properties"));
        GuiHelper.addComponentAligned(this, this._profilePropertiesPanel);
        this.updateProfilePropertiesPanel();
    }

    private void updateProfilePropertiesPanel() {
        this._propertyFields.clear();
        this._profilePropertiesPanel.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._profilePropertiesPanel.setLayout(gridBagLayout);
        String[] propertyNames = this._profileDescriptor.getPropertyNames();
        int i = 0;
        while (i < propertyNames.length) {
            String property = propertyNames[i];
            JLabel label = new JLabel(property);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridy = i++;
            constraints.gridx = 0;
            constraints.ipadx = 10;
            gridBagLayout.addLayoutComponent(label, constraints);
            this._profilePropertiesPanel.add(label);
            JTextField textField = new JTextField(30);
            constraints.gridx = 1;
            gridBagLayout.addLayoutComponent(textField, constraints);
            this._profilePropertiesPanel.add(textField);
            this._propertyFields.put(property, textField);
        }
    }

    public ProfileConfiguration getProfileConfiguration() {
        ProfileConfiguration profileConfiguration = new ProfileConfiguration(this._profileDescriptor);
        Set<String> keySet = this._propertyFields.keySet();
        for (String property : keySet) {
            JTextField textField = this._propertyFields.get(property);
            String value = textField.getText();
            if (value == null || value.trim().length() <= 0) continue;
            profileConfiguration.addProfileProperty(property, value);
        }
        profileConfiguration.setColumns(this._subsetDataSelectionPanel.getSelectedColumns());
        return profileConfiguration;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        _log.debug((Object)"Closing profile configuration panel");
        this._subsetDataSelectionPanel.close();
        this._profileDescriptor = null;
        this._propertyFields = null;
    }
}

