/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.catalog.NamedRegex;
import dk.eobjects.datacleaner.gui.dialogs.TestRegexDialog;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.AbstractValidationRuleConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.SubsetDataSelectionPanel;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexValidationRuleConfigurationPanel
extends AbstractValidationRuleConfigurationPanel {
    private SubsetDataSelectionPanel _subsetDataSelectionPanel;
    private JTextField _expressionField;
    private JButton _testButton;
    private static final long serialVersionUID = -1664543587469991507L;

    public RegexValidationRuleConfigurationPanel(JTabbedPane tabbedPane, final IValidationRuleDescriptor descriptor, ColumnSelection dataSelection) {
        super(tabbedPane, descriptor, dataSelection);
        JPanel expressionPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._expressionField = new JTextField(30);
        expressionPanel.add(this._expressionField);
        this._testButton = new JButton("Test it");
        this._testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestRegexDialog dialog = new TestRegexDialog(RegexValidationRuleConfigurationPanel.this._expressionField.getText());
                dialog.setVisible(true);
            }
        });
        expressionPanel.add(this._testButton);
        this.addPropertyField("Expression", expressionPanel);
        final List<NamedRegex> regexes = GuiSettings.getSettings().getRegexes();
        Object[] items = ReflectionHelper.getProperties(regexes, (String)"name");
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(items));
        list.add(0, "-");
        final JComboBox<Object> regexCatalogDropdown = new JComboBox<Object>(list.toArray());
        regexCatalogDropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = regexCatalogDropdown.getSelectedIndex();
                if (index == 0) {
                    RegexValidationRuleConfigurationPanel.this._expressionField.setText("");
                } else {
                    NamedRegex regex = (NamedRegex)regexes.get(index - 1);
                    RegexValidationRuleConfigurationPanel.this._expressionField.setText(regex.getExpression());
                }
            }
        });
        this.addPropertyField("Select from catalog...", regexCatalogDropdown);
        this._subsetDataSelectionPanel = new SubsetDataSelectionPanel(dataSelection){
            private static final long serialVersionUID = -5227491742509256691L;

            protected boolean isSupported(ColumnType type) {
                return descriptor.isSupported(type);
            }
        };
        this.add(this._subsetDataSelectionPanel);
    }

    @Override
    protected boolean autoGeneratePropertyFields() {
        return false;
    }

    @Override
    protected Column[] getColumns(ColumnSelection dataSelection) {
        List<Column> columns = this._subsetDataSelectionPanel.getSelectedColumns();
        return columns.toArray(new Column[columns.size()]);
    }

    @Override
    protected void handleProperties(Map<String, String> properties) {
        properties.put("Regular expression", this._expressionField.getText());
    }

    @Override
    public void close() throws IOException {
        this._subsetDataSelectionPanel.close();
    }
}

