/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubsetDataSelectionPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 3797363932708302358L;
    private static final Log _log = LogFactory.getLog(SubsetDataSelectionPanel.class);
    private ColumnSelection _dataSelection;
    private JRadioButton _allDataRadio;
    private JRadioButton _subsetRadio;
    private JPanel _subsetPanel;
    private List<JCheckBox> _subsetCheckBoxes = new ArrayList<JCheckBox>();

    public SubsetDataSelectionPanel(ColumnSelection dataSelection) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder("Apply to"));
        this._dataSelection = dataSelection;
        this._dataSelection.addObserver(this);
        this._allDataRadio = new JRadioButton("All selected data.", true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._allDataRadio);
        this.add(this._allDataRadio);
        this._subsetRadio = new JRadioButton("Subset of data:");
        buttonGroup.add(this._subsetRadio);
        this.add(this._subsetRadio);
        this._subsetPanel = new JPanel();
        this._subsetPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        this._subsetPanel.setLayout(new BoxLayout(this._subsetPanel, 1));
        this.add(this._subsetPanel);
        this.updateProfileDataPanel();
    }

    private void updateProfileDataPanel() {
        this._allDataRadio.setSelected(true);
        this._allDataRadio.setEnabled(true);
        this._subsetPanel.removeAll();
        this._subsetCheckBoxes.clear();
        List<Column> columns = this._dataSelection.getColumns();
        for (Column column : columns) {
            boolean enabled = this.isSupported(column.getType());
            this._subsetPanel.add(this.createCheckBox(GuiHelper.getDataSelectionLabel(column), enabled));
            if (enabled) continue;
            this._allDataRadio.setSelected(false);
            this._subsetRadio.setSelected(true);
            this._allDataRadio.setEnabled(false);
        }
        if (!this._allDataRadio.isEnabled()) {
            for (int i = 0; i < this._subsetCheckBoxes.size(); ++i) {
                JCheckBox checkBox = this._subsetCheckBoxes.get(i);
                if (!checkBox.isEnabled()) continue;
                checkBox.setSelected(true);
            }
        }
    }

    protected abstract boolean isSupported(ColumnType var1);

    private Component createCheckBox(String string, boolean enabled) {
        final JCheckBox checkBox = new JCheckBox(string, false);
        checkBox.setEnabled(enabled);
        checkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -1016745652729471191L;

            public void actionPerformed(ActionEvent e) {
                if (checkBox.isSelected()) {
                    SubsetDataSelectionPanel.this._subsetRadio.setSelected(true);
                }
            }
        });
        this._subsetCheckBoxes.add(checkBox);
        return checkBox;
    }

    public List<Column> getSelectedColumns() {
        if (this._subsetRadio.isSelected()) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (JCheckBox checkBox : this._subsetCheckBoxes) {
                if (!checkBox.isSelected()) continue;
                String label = checkBox.getText();
                Column column = GuiHelper.getColumnByLabel(this._dataSelection, label);
                columns.add(column);
            }
            return columns;
        }
        return this._dataSelection.getColumns();
    }

    @Override
    public void update(Observable o, Object arg1) {
        if (o instanceof ColumnSelection) {
            this.updateProfileDataPanel();
        }
    }

    public JRadioButton getAllDataRadio() {
        return this._allDataRadio;
    }

    public JRadioButton getSubsetRadio() {
        return this._subsetRadio;
    }

    public List<JCheckBox> getSubsetCheckBoxes() {
        return this._subsetCheckBoxes;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        _log.debug((Object)"Closing subset data selection panel");
        this._dataSelection.deleteObserver(this);
        this._subsetCheckBoxes = null;
    }
}

