/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.widgets.MatrixTable;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.IProfileResult;
import dk.eobjects.datacleaner.profiler.ProfilerHelper;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableProfileResultsPanel
extends JPanel {
    private static final long serialVersionUID = 7504166314384076977L;

    public TableProfileResultsPanel(DataContext dataContext, Table table, List<IProfileResult> results) {
        this.setLayout(new BorderLayout());
        JXTaskPaneContainer taskPaneContainer = new JXTaskPaneContainer();
        JLabel label = new JLabel("Profile results for " + table.getName());
        label.setFont(GuiHelper.HEADER_FONT);
        taskPaneContainer.add((Component)label);
        Map profiles = ProfilerHelper.getProfileResultsByProfileDescriptor(results);
        Set profileDescriptors = profiles.keySet();
        for (IProfileDescriptor profileDescriptor : profileDescriptors) {
            List profileResults = (List)profiles.get(profileDescriptor);
            String displayName = profileDescriptor.getDisplayName();
            int matrixNumber = 0;
            for (IProfileResult profileResult : profileResults) {
                Exception error = profileResult.getError();
                if (error != null) {
                    JXTaskPane taskPane = new JXTaskPane();
                    taskPane.setIcon((Icon)GuiHelper.getImageIcon(profileDescriptor.getIconPath()));
                    taskPane.setAnimated(false);
                    taskPane.setExpanded(true);
                    taskPane.setTitle(displayName);
                    JLabel errorLabel = new JLabel(error.getMessage());
                    errorLabel.setFont(errorLabel.getFont().deriveFont(1));
                    taskPane.add((Component)errorLabel);
                    taskPane.add((Component)new JLabel("See the log for details."));
                    taskPaneContainer.add(taskPane);
                    continue;
                }
                IMatrix[] matrices = profileResult.getMatrices();
                for (int j = 0; j < matrices.length; ++j) {
                    ++matrixNumber;
                    JXTaskPane taskPane = new JXTaskPane();
                    taskPane.setIcon((Icon)GuiHelper.getImageIcon(profileDescriptor.getIconPath()));
                    taskPane.setAnimated(false);
                    taskPane.setExpanded(true);
                    IMatrix matrix = matrices[j];
                    String[] columnNames = matrix.getColumnNames();
                    if (matrices.length > 1) {
                        if (columnNames.length == 1) {
                            taskPane.setTitle(displayName + " (" + columnNames[0] + ")");
                        } else {
                            taskPane.setTitle(displayName + " #" + matrixNumber);
                        }
                    } else {
                        taskPane.setTitle(displayName);
                    }
                    MatrixTable matrixTable = new MatrixTable(matrix, dataContext);
                    JPanel matrixPanel = new JPanel(new BorderLayout());
                    matrixPanel.add((Component)matrixTable.getTableHeader(), "North");
                    matrixPanel.add((Component)((Object)matrixTable), "Center");
                    taskPane.add((Component)matrixPanel);
                    taskPaneContainer.add(taskPane);
                }
            }
        }
        this.add((Component)taskPaneContainer, "Center");
    }
}

