/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.setup;

import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.ProfileManager;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.ValidationRuleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiConfiguration {
    public static final String CONFIGURATION_FILE = "datacleaner-config.xml";
    private static Log _log = LogFactory.getLog(GuiConfiguration.class);
    private static XmlBeanFactory _beanFactory;

    private GuiConfiguration() {
    }

    public static void initialize(String configurationFile) {
        _log.info((Object)("Reading configuration file: " + configurationFile));
        FileSystemResource fileSystemResource = new FileSystemResource(configurationFile);
        if (fileSystemResource.exists()) {
            _beanFactory = new XmlBeanFactory((Resource)fileSystemResource);
            Collection<IProfileDescriptor> pd = GuiConfiguration.getBeansOfClass(IProfileDescriptor.class);
            ProfileManager.setProfileDescriptors(new ArrayList<IProfileDescriptor>(pd));
            Collection<IValidationRuleDescriptor> vrd = GuiConfiguration.getBeansOfClass(IValidationRuleDescriptor.class);
            ValidationRuleManager.setValidationRuleDescriptors(new ArrayList<IValidationRuleDescriptor>(vrd));
        } else {
            _log.fatal((Object)"Could not open configuration file: datacleaner-config.xml");
            System.exit(15);
        }
    }

    public static void initialize() {
        GuiConfiguration.initialize(CONFIGURATION_FILE);
    }

    public static <E> Collection<E> getBeansOfClass(Class<E> clazz) {
        Map beansOfType = _beanFactory.getBeansOfType(clazz);
        return beansOfType.values();
    }
}

