/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.tasks;

import dk.eobjects.datacleaner.execution.IProgressObserver;
import dk.eobjects.datacleaner.execution.IRunner;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.tasks.AbstractTaskRunner;
import dk.eobjects.datacleaner.gui.windows.LogResultWindow;
import dk.eobjects.metamodel.schema.Table;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class RunnerWrapper
extends AbstractTaskRunner
implements PropertyChangeListener,
IProgressObserver {
    private IRunner _runner;
    private DataContextSelection _schemaSelection;
    private LogResultWindow _logInternalFrame;
    private int _tableCounter;
    private int _totalTables;
    private String _tableName;

    public RunnerWrapper(DataContextSelection schemaSelection, IRunner runner, LogResultWindow logInternalFrame) {
        this._schemaSelection = schemaSelection;
        this._runner = runner;
        this._logInternalFrame = logInternalFrame;
        this.addPropertyChangeListener(this);
    }

    public void runTask() {
        this._runner.addProgressObserver((IProgressObserver)this);
        this._runner.execute(this._schemaSelection.getDataContext());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this._logInternalFrame.getProgressBar().setValue(progress);
            this._logInternalFrame.setStatusBarMessage("Analyzing: " + this._tableName);
        }
    }

    protected void done() {
        Toolkit.getDefaultToolkit().beep();
        this._logInternalFrame.setStatusBarMessage("Done.");
        this.whenDone();
    }

    public abstract void whenDone();

    public void init(Object[] executingObjects) {
        this._totalTables = executingObjects.length;
        this._tableCounter = 0;
    }

    public void notifyExecutionBegin(Object executingObject) {
        ++this._tableCounter;
        if (executingObject instanceof Table) {
            this._tableName = ((Table)executingObject).getName();
        }
    }

    public void notifyExecutionFailed(Object executingObject, Throwable throwable) {
    }

    public void notifyExecutionSuccess(Object executingObject) {
        int progress = Math.round(100 * this._tableCounter / this._totalTables);
        this.setProgress(progress);
    }
}

