/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.ProfileConfigurationPanel;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.ProfileManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class AddProfileButton
extends JButton {
    private static final long serialVersionUID = -3189155332753633377L;
    private ColumnSelection _dataSelection;
    private JTabbedPane _tabbedPane;

    public AddProfileButton(ColumnSelection dataSelection, JTabbedPane tabbedPane) {
        this._dataSelection = dataSelection;
        this._tabbedPane = tabbedPane;
        this.setAction(new AbstractAction(){
            private static final long serialVersionUID = 7563261102481973816L;

            public void actionPerformed(ActionEvent e) {
                AddProfileButton.this.showPopup();
            }
        });
        this.setText("Add profile");
        this.setIcon(GuiHelper.getImageIcon("images/toolbar_add.png"));
    }

    public void showPopup() {
        IProfileDescriptor[] profileDescriptors;
        JPopupMenu popup = new JPopupMenu("Profiles");
        for (IProfileDescriptor profileDescriptor : profileDescriptors = ProfileManager.getProfileDescriptors()) {
            JMenuItem item = this.createProfileItem(profileDescriptor, this._tabbedPane);
            popup.add(item);
        }
        popup.show(this, 0, this.getHeight());
    }

    private JMenuItem createProfileItem(final IProfileDescriptor pd, final JTabbedPane tabbedPane) {
        final ImageIcon icon = GuiHelper.getImageIcon(pd.getIconPath());
        JMenuItem item = new JMenuItem();
        item.setAction(new AbstractAction(){
            private static final long serialVersionUID = -64934142667337299L;

            public void actionPerformed(ActionEvent e) {
                ProfileConfigurationPanel panel = new ProfileConfigurationPanel(pd, AddProfileButton.this._dataSelection);
                tabbedPane.addTab(pd.getDisplayName(), icon, new JScrollPane(panel));
            }
        });
        item.setIcon(icon);
        item.setText(pd.getDisplayName());
        return item;
    }
}

