/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.DefaultValidationRuleConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.DictionaryValidationRuleConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.JavascriptValidationRuleConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.RegexValidationRuleConfigurationPanel;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.ValidationRuleManager;
import dk.eobjects.datacleaner.validator.condition.JavascriptValidationRule;
import dk.eobjects.datacleaner.validator.dictionary.DictionaryValidationRule;
import dk.eobjects.datacleaner.validator.trivial.RegexValidationRule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class AddValidationRuleButton
extends JButton {
    private static final long serialVersionUID = 451961366258616382L;
    private ColumnSelection _dataSelection;
    private final JTabbedPane _tabbedPane;

    public AddValidationRuleButton(ColumnSelection dataSelection, JTabbedPane tabbedPane) {
        super("Add validation rule", GuiHelper.getImageIcon("images/toolbar_add.png"));
        this._dataSelection = dataSelection;
        this._tabbedPane = tabbedPane;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddValidationRuleButton.this.showPopup();
            }
        });
    }

    public void showPopup() {
        JPopupMenu popup = new JPopupMenu("Profiles");
        popup.add(this.createJavascriptValidationRuleItem());
        popup.add(this.createDictionaryValidationRuleItem());
        popup.add(this.createRegexValidationRuleItem());
        IValidationRuleDescriptor[] validationRuleDescriptors = ValidationRuleManager.getValidationRuleDescriptors();
        for (int i = 0; i < validationRuleDescriptors.length; ++i) {
            IValidationRuleDescriptor descriptor = validationRuleDescriptors[i];
            Class validationRuleClass = descriptor.getValidationRuleClass();
            if (validationRuleClass == JavascriptValidationRule.class || validationRuleClass == DictionaryValidationRule.class || validationRuleClass == RegexValidationRule.class) continue;
            popup.add(this.createValidationRuleItem(descriptor));
        }
        popup.show(this, 0, this.getHeight());
    }

    private JMenuItem createValidationRuleItem(final IValidationRuleDescriptor descriptor) {
        final ImageIcon icon = GuiHelper.getImageIcon(descriptor.getIconPath());
        final String displayName = descriptor.getDisplayName();
        JMenuItem item = new JMenuItem(displayName, icon);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddValidationRuleButton.this._tabbedPane.addTab(displayName, icon, new JScrollPane(new DefaultValidationRuleConfigurationPanel(AddValidationRuleButton.this._tabbedPane, descriptor, AddValidationRuleButton.this._dataSelection)));
            }
        });
        return item;
    }

    private JMenuItem createJavascriptValidationRuleItem() {
        final IValidationRuleDescriptor descriptor = ValidationRuleManager.getValidationRuleDescriptorByValidationRuleClass(JavascriptValidationRule.class);
        final ImageIcon icon = GuiHelper.getImageIcon(descriptor.getIconPath());
        final String displayName = descriptor.getDisplayName();
        JMenuItem item = new JMenuItem(displayName, icon);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddValidationRuleButton.this._tabbedPane.addTab(displayName, icon, new JScrollPane(new JavascriptValidationRuleConfigurationPanel(AddValidationRuleButton.this._tabbedPane, descriptor, AddValidationRuleButton.this._dataSelection)));
            }
        });
        return item;
    }

    private JMenuItem createDictionaryValidationRuleItem() {
        final IValidationRuleDescriptor descriptor = ValidationRuleManager.getValidationRuleDescriptorByValidationRuleClass(DictionaryValidationRule.class);
        final ImageIcon icon = GuiHelper.getImageIcon(descriptor.getIconPath());
        final String displayName = descriptor.getDisplayName();
        JMenuItem item = new JMenuItem(displayName, icon);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddValidationRuleButton.this._tabbedPane.addTab(displayName, icon, new JScrollPane(new DictionaryValidationRuleConfigurationPanel(AddValidationRuleButton.this._tabbedPane, descriptor, AddValidationRuleButton.this._dataSelection)));
            }
        });
        return item;
    }

    private JMenuItem createRegexValidationRuleItem() {
        final IValidationRuleDescriptor descriptor = ValidationRuleManager.getValidationRuleDescriptorByValidationRuleClass(RegexValidationRule.class);
        final ImageIcon icon = GuiHelper.getImageIcon(descriptor.getIconPath());
        final String displayName = descriptor.getDisplayName();
        JMenuItem item = new JMenuItem(displayName, icon);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddValidationRuleButton.this._tabbedPane.addTab(displayName, icon, new JScrollPane(new RegexValidationRuleConfigurationPanel(AddValidationRuleButton.this._tabbedPane, descriptor, AddValidationRuleButton.this._dataSelection)));
            }
        });
        return item;
    }
}

