/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCleanerTable
extends JXTable
implements MouseListener {
    private static final long serialVersionUID = -5376226138423224572L;
    protected Log _log = LogFactory.getLog(this.getClass());
    protected List<JMenuItem> _rightClickMenuItems;

    public DataCleanerTable() {
        this.setHighlighters(new Highlighter[]{GuiHelper.LIBERELLO_HIGHLIGHTER});
        this.getTableHeader().setReorderingAllowed(true);
        this.setAutoResizeMode(4);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setColumnControlVisible(true);
        this.setSortable(true);
        this.setEditable(false);
        this.addMouseListener(this);
        this._rightClickMenuItems = this.getCopyMenuItems();
    }

    public JPanel toPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getTableHeader(), "North");
        panel.add((Component)((Object)this), "Center");
        return panel;
    }

    protected List<JMenuItem> getCopyMenuItems() {
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        JMenuItem copySelectedItem = new JMenuItem(new AbstractAction(){
            private static final long serialVersionUID = 3927213487060526074L;

            public void actionPerformed(ActionEvent e) {
                int rowIndex = DataCleanerTable.this.getSelectedRow();
                int rowCount = DataCleanerTable.this.getSelectedRowCount();
                int colIndex = DataCleanerTable.this.getSelectedColumn();
                int colCount = DataCleanerTable.this.getSelectedColumnCount();
                DataCleanerTable.this.copyToClipboard(rowIndex, colIndex, colCount, rowCount);
            }
        });
        copySelectedItem.setText("Copy selected cells to clipboard");
        result.add(copySelectedItem);
        JMenuItem copyTableItem = new JMenuItem(new AbstractAction(){
            private static final long serialVersionUID = -1596607781278450492L;

            public void actionPerformed(ActionEvent e) {
                DataCleanerTable.this.copyToClipboard(0, 0, DataCleanerTable.this.getColumnCount(), DataCleanerTable.this.getRowCount());
            }
        });
        copyTableItem.setText("Copy entire table to clipboard");
        result.add(copyTableItem);
        return result;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int button;
        if (e.getClickCount() == 1 && ((button = e.getButton()) == 2 || button == 3) && this._rightClickMenuItems != null && this._rightClickMenuItems.size() > 0) {
            JPopupMenu popup = new JPopupMenu();
            for (JMenuItem item : this._rightClickMenuItems) {
                popup.add(item);
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void copyToClipboard(int rowIndex, int colIndex, int width, int height) {
        StringBuilder sb = new StringBuilder();
        if (rowIndex == 0 && colIndex == 0 && width == this.getColumnCount() && height == this.getRowCount()) {
            for (int i = 0; i < width; ++i) {
                sb.append(this.getColumnName(i));
                if (i >= height - 1) continue;
                sb.append("\t");
            }
            sb.append("\n");
        }
        for (int row = rowIndex; row < rowIndex + height; ++row) {
            for (int col = colIndex; col < colIndex + width; ++col) {
                Object value = this.getValueAt(row, col);
                if (value instanceof MatrixValue) {
                    value = ((MatrixValue)value).getValue();
                }
                if (value == null) {
                    value = "";
                }
                sb.append(value);
                sb.append("\t");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stsel = new StringSelection(sb.toString());
        clipboard.setContents(stsel, stsel);
    }
}

