/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.comparator.ColumnComparator;
import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.windows.ComparisonResultWindow;
import dk.eobjects.metamodel.data.DataSet;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.OrderByItem;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunComparisonButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 3477825266323556984L;
    private static final Log _log = LogFactory.getLog(RunComparisonButton.class);
    private DataContextSelection _leftDataContextSelection;
    private DataContextSelection _rightDataContextSelection;
    private ColumnSelection _leftColumnSelection;
    private ColumnSelection _rightColumnSelection;

    public RunComparisonButton(DataContextSelection leftDataContextSelection, DataContextSelection rightDataContextSelection, ColumnSelection leftColumnSelection, ColumnSelection rightColumnSelection) {
        this._leftDataContextSelection = leftDataContextSelection;
        this._rightDataContextSelection = rightDataContextSelection;
        this._leftColumnSelection = leftColumnSelection;
        this._rightColumnSelection = rightColumnSelection;
        this.setIcon(GuiHelper.getImageIcon("images/toolbar_run.png"));
        this.setText("Run comparison");
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        Iterator<Column> leftIterator = this._leftColumnSelection.getColumns().iterator();
        Iterator<Column> rightIterator = this._rightColumnSelection.getColumns().iterator();
        ComparisonResultWindow resultFrame = new ComparisonResultWindow();
        DataCleanerGui.getMainWindow().addWindow(resultFrame);
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            Column leftColumn = leftIterator.next();
            Column rightColumn = rightIterator.next();
            resultFrame.addLogMessage("Comparing columns: " + leftColumn + " and " + rightColumn);
            try {
                DataSet leftData = this.executeQuery(this._leftDataContextSelection, leftColumn);
                DataSet rightData = this.executeQuery(this._rightDataContextSelection, rightColumn);
                ColumnComparator columnComparator = new ColumnComparator();
                columnComparator.initialize(new Column[]{leftColumn, rightColumn});
                boolean leftNext = leftData.next();
                boolean rightNext = rightData.next();
                while (leftNext || rightNext) {
                    Long count;
                    Row row;
                    if (leftNext) {
                        row = leftData.getRow();
                        count = ((Number)row.getValue(1)).longValue();
                        columnComparator.processValue(leftColumn, row.getValue(0), count.longValue());
                        leftNext = leftData.next();
                    }
                    if (!rightNext) continue;
                    row = rightData.getRow();
                    count = ((Number)row.getValue(1)).longValue();
                    columnComparator.processValue(rightColumn, row.getValue(0), count.longValue());
                    rightNext = rightData.next();
                }
                leftData.close();
                rightData.close();
                resultFrame.addResults(columnComparator);
            }
            catch (Exception e) {
                _log.error((Object)e);
                resultFrame.addLogMessage("Error occurred: " + e.getMessage());
            }
        }
    }

    private DataSet executeQuery(DataContextSelection dataContextSelection, Column column) {
        Query q = new Query();
        q.select(new Column[]{column}).selectCount();
        q.from(column.getTable());
        q.groupBy(new Column[]{column});
        q.orderBy(new OrderByItem[]{new OrderByItem(new SelectItem(column))});
        return dataContextSelection.getDataContext().executeQuery(q);
    }
}

