/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.execution.IProgressObserver;
import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.execution.IRunner;
import dk.eobjects.datacleaner.execution.ProfileRunner;
import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.panels.ProfileConfigurationPanel;
import dk.eobjects.datacleaner.gui.tasks.RunnerWrapper;
import dk.eobjects.datacleaner.gui.widgets.LogInternalFrameProgressObserver;
import dk.eobjects.datacleaner.gui.windows.ProfileResultWindow;
import dk.eobjects.datacleaner.profiler.ProfileConfiguration;
import dk.eobjects.metamodel.schema.Table;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class RunProfilingButton
extends JButton {
    private static final long serialVersionUID = 6789940894608611387L;

    public RunProfilingButton(final DataContextSelection dataContextSelection, final JTabbedPane tabbedPane) {
        this.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8646982169706441278L;

            public void actionPerformed(ActionEvent e) {
                final ProfileRunner profileRunner = new ProfileRunner();
                boolean foundConfiguration = false;
                Component[] components = tabbedPane.getComponents();
                for (int i = 0; i < components.length; ++i) {
                    Component component = components[i];
                    if (component instanceof JScrollPane) {
                        component = ((JScrollPane)component).getViewport().getComponent(0);
                    }
                    if (!(component instanceof ProfileConfigurationPanel)) continue;
                    ProfileConfigurationPanel profileConfigurationPanel = (ProfileConfigurationPanel)component;
                    ProfileConfiguration profileConfiguration = profileConfigurationPanel.getProfileConfiguration();
                    if (profileConfiguration.getColumns().length > 0) {
                        foundConfiguration = true;
                    }
                    profileRunner.addConfiguration((IRunnableConfiguration)profileConfiguration);
                }
                if (foundConfiguration) {
                    final ProfileResultWindow internalFrame = new ProfileResultWindow();
                    DataCleanerGui.getMainWindow().addWindow(internalFrame);
                    profileRunner.addProgressObserver((IProgressObserver)new LogInternalFrameProgressObserver(internalFrame));
                    RunnerWrapper runnerWrapper = new RunnerWrapper(dataContextSelection, (IRunner)profileRunner, internalFrame){

                        public void whenDone() {
                            Table[] tables = profileRunner.getResultTables();
                            for (int j = 0; j < tables.length; ++j) {
                                Table table = tables[j];
                                List results = profileRunner.getResultsForTable(table);
                                internalFrame.addResults(table, results, dataContextSelection.getDataContext());
                            }
                        }
                    };
                    runnerWrapper.execute();
                } else {
                    GuiHelper.showErrorMessage("Can't run profiling", "You need to select data and add profiles to run profiling.", new IllegalStateException());
                }
            }
        });
        this.setIcon(GuiHelper.getImageIcon("images/toolbar_run.png"));
        this.setText("Run profiling");
    }
}

