/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.execution.IProgressObserver;
import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.execution.IRunner;
import dk.eobjects.datacleaner.execution.ValidationRuleRunner;
import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.panels.AbstractValidationRuleConfigurationPanel;
import dk.eobjects.datacleaner.gui.tasks.RunnerWrapper;
import dk.eobjects.datacleaner.gui.widgets.LogInternalFrameProgressObserver;
import dk.eobjects.datacleaner.gui.windows.ValidationRuleResultWindow;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.datacleaner.validator.trivial.DummyValidationRule;
import dk.eobjects.metamodel.schema.Table;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class RunValidationButton
extends JButton {
    private static final long serialVersionUID = -4118642086709810954L;

    public RunValidationButton(final DataContextSelection schemaSelection, final ColumnSelection dataSelection, final JTabbedPane tabbedPane) {
        this.setAction(new AbstractAction(){
            private static final long serialVersionUID = 2631447482897482265L;

            public void actionPerformed(ActionEvent e) {
                final ValidationRuleRunner validationRuleRunner = new ValidationRuleRunner();
                boolean foundConfiguration = false;
                Component[] components = tabbedPane.getComponents();
                for (int i = 0; i < components.length; ++i) {
                    AbstractValidationRuleConfigurationPanel panel;
                    ValidationRuleConfiguration configuration;
                    Component component = components[i];
                    if (component instanceof JScrollPane) {
                        component = ((JScrollPane)component).getViewport().getComponent(0);
                    }
                    if (component instanceof AbstractValidationRuleConfigurationPanel && (configuration = (panel = (AbstractValidationRuleConfigurationPanel)component).getValidationRuleConfiguration()).getColumns().length > 0) {
                        foundConfiguration = true;
                        validationRuleRunner.addConfiguration((IRunnableConfiguration)configuration);
                    }
                    if (!foundConfiguration) continue;
                    ValidationRuleConfiguration dummyConfiguration = new ValidationRuleConfiguration(DummyValidationRule.DESCRIPTOR);
                    dummyConfiguration.setColumns(dataSelection.getColumns());
                    dummyConfiguration.setValidationRuleProperties(new HashMap());
                    validationRuleRunner.addConfiguration((IRunnableConfiguration)dummyConfiguration);
                }
                if (foundConfiguration) {
                    final ValidationRuleResultWindow internalFrame = new ValidationRuleResultWindow(dataSelection);
                    DataCleanerGui.getMainWindow().addWindow(internalFrame);
                    validationRuleRunner.addProgressObserver((IProgressObserver)new LogInternalFrameProgressObserver(internalFrame));
                    RunnerWrapper runnerWrapper = new RunnerWrapper(schemaSelection, (IRunner)validationRuleRunner, internalFrame){

                        public void whenDone() {
                            Table[] tables = validationRuleRunner.getResultTables();
                            for (int j = 0; j < tables.length; ++j) {
                                Table table = tables[j];
                                List results = validationRuleRunner.getResultsForTable(table);
                                internalFrame.addResults(table, results);
                            }
                        }
                    };
                    runnerWrapper.execute();
                } else {
                    GuiHelper.showErrorMessage("Can't run validation", "You need to select data and add validation rules to run validation.", new IllegalStateException());
                }
            }
        });
        this.setIcon(GuiHelper.getImageIcon("images/toolbar_run.png"));
        this.setText("Run validation");
    }
}

