/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Schema;
import dk.eobjects.metamodel.schema.Table;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SchemaTree
extends JTree
implements Observer {
    public static final String UNNAMED_SCHEMA_STRING = "(unnamed schema)";
    public static final String ROOT_NODE_STRING = "Schemas";
    private static final long serialVersionUID = 7763827443642264329L;

    public SchemaTree(DataContextSelection dataContextSelection) {
        dataContextSelection.addObserver(this);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("No data selected");
        DefaultTreeModel treeModel = new DefaultTreeModel(node);
        this.setModel(treeModel);
    }

    private void updateTree(DataContextSelection dataContextSelection) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        rootNode.setUserObject(ROOT_NODE_STRING);
        DataContext dataContext = dataContextSelection.getDataContext();
        if (dataContext == null) {
            rootNode.setUserObject("No data selected");
        } else {
            Schema[] schemas = dataContext.getSchemas();
            for (int i = 0; i < schemas.length; ++i) {
                Schema schema = schemas[i];
                String schemaName = schema.getName();
                if (schemaName == null) {
                    schemaName = UNNAMED_SCHEMA_STRING;
                }
                DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schemaName);
                Table[] tables = schema.getTables();
                for (int j = 0; j < tables.length; ++j) {
                    Table table = tables[j];
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table.getName());
                    Column[] columns = table.getColumns();
                    for (int k = 0; k < columns.length; ++k) {
                        Column column = columns[k];
                        DefaultMutableTreeNode columnNode = new DefaultMutableTreeNode(column.getName());
                        tableNode.add(columnNode);
                    }
                    schemaNode.add(tableNode);
                }
                rootNode.add(schemaNode);
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.setModel(treeModel);
    }

    public void update(Observable o, Object arg) {
        if (o instanceof DataContextSelection) {
            this.updateTree((DataContextSelection)o);
        }
    }

    public static Column getColumn(Table table, TreePath path) {
        if (path.getPathCount() >= 4) {
            return table.getColumnByName(path.getPathComponent(3).toString());
        }
        return null;
    }

    public static Table getTable(Schema schema, TreePath path) {
        if (path.getPathCount() >= 3) {
            return schema.getTableByName(path.getPathComponent(2).toString());
        }
        return null;
    }

    public static Schema getSchema(DataContext dc, TreePath path) {
        if (path.getPathCount() >= 2) {
            String schemaName = path.getPathComponent(1).toString();
            if (UNNAMED_SCHEMA_STRING.equals(schemaName)) {
                schemaName = null;
            }
            Schema schema = dc.getSchemaByName(schemaName);
            return schema;
        }
        return null;
    }
}

