/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.widgets.SchemaTree;
import dk.eobjects.datacleaner.gui.windows.PreviewDataWindow;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Schema;
import dk.eobjects.metamodel.schema.Table;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class SchemaTreeMouseListener
extends MouseAdapter {
    private JTree _tree;
    private DataContextSelection _schemaSelection;
    private ColumnSelection _dataSelection;

    public SchemaTreeMouseListener(JTree tree, DataContextSelection schemaSelection, ColumnSelection dataSelection) {
        this._tree = tree;
        this._schemaSelection = schemaSelection;
        this._dataSelection = dataSelection;
    }

    public void mousePressed(MouseEvent e) {
        int selRow = this._tree.getRowForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            TreePath path = this._tree.getPathForLocation(e.getX(), e.getY());
            this._tree.setSelectionPath(path);
            Schema schema = SchemaTree.getSchema(this._schemaSelection.getDataContext(), path);
            Table table = SchemaTree.getTable(schema, path);
            Column column = SchemaTree.getColumn(table, path);
            if (e.getClickCount() == 1) {
                JPopupMenu popup;
                int button = e.getButton();
                if ((button == 2 || button == 3) && (popup = this.handleRightClick(schema, table, column)) != null) {
                    popup.show(this._tree, e.getX(), e.getY());
                }
            } else if (e.getClickCount() == 2) {
                this.handleDoubleClick(schema, table, column);
            }
        }
    }

    private JPopupMenu handleRightClick(final Schema schema, final Table table, final Column column) {
        if (schema != null) {
            if (table != null) {
                if (column == null) {
                    JPopupMenu popup = new JPopupMenu(table.getName());
                    JMenuItem toggleColumnsItem = new JMenuItem(new AbstractAction(){
                        private static final long serialVersionUID = -7810055611434508216L;

                        public void actionPerformed(ActionEvent e) {
                            SchemaTreeMouseListener.this._dataSelection.toggleTable(table);
                        }
                    });
                    toggleColumnsItem.setText("Toggle table columns in data selection");
                    toggleColumnsItem.setIcon(GuiHelper.getImageIcon("images/toolbar_toggle_data.png"));
                    popup.add(toggleColumnsItem);
                    JMenuItem previewTableItem = new JMenuItem(new AbstractAction(){
                        private static final long serialVersionUID = 8582750767677925420L;

                        public void actionPerformed(ActionEvent arg0) {
                            DataContext dataContext = SchemaTreeMouseListener.this._schemaSelection.getDataContext();
                            DataCleanerGui.getMainWindow().addWindow(new PreviewDataWindow(table, table.getColumns(), dataContext, 40));
                        }
                    });
                    previewTableItem.setIcon(GuiHelper.getImageIcon("images/toolbar_preview_data.png"));
                    previewTableItem.setText("Preview table");
                    popup.add(previewTableItem);
                    return popup;
                }
                JPopupMenu popup = new JPopupMenu(column.getName());
                JMenuItem toggleColumnItem = new JMenuItem(new AbstractAction(){
                    private static final long serialVersionUID = -7810055611434508216L;

                    public void actionPerformed(ActionEvent e) {
                        SchemaTreeMouseListener.this._dataSelection.toggleColumn(column);
                    }
                });
                if (this._dataSelection.isSelected(column)) {
                    toggleColumnItem.setText("Remove column from data selection");
                } else {
                    toggleColumnItem.setText("Add column to data selection");
                }
                toggleColumnItem.setIcon(GuiHelper.getImageIcon("images/toolbar_toggle_data.png"));
                popup.add(toggleColumnItem);
                return popup;
            }
            JPopupMenu popup = new JPopupMenu(schema.getName());
            JMenuItem toggleColumnsItem = new JMenuItem(new AbstractAction(){
                private static final long serialVersionUID = -7810055611434508216L;

                public void actionPerformed(ActionEvent e) {
                    Table[] tables = schema.getTables();
                    for (int i = 0; i < tables.length; ++i) {
                        SchemaTreeMouseListener.this._dataSelection.toggleTable(tables[i]);
                    }
                }
            });
            toggleColumnsItem.setText("Toggle schema columns in data selection");
            toggleColumnsItem.setIcon(GuiHelper.getImageIcon("images/toolbar_toggle_data.png"));
            popup.add(toggleColumnsItem);
            return popup;
        }
        return null;
    }

    private void handleDoubleClick(Schema schema, Table table, Column column) {
        if (table != null) {
            if (column == null) {
                this._dataSelection.toggleTable(table);
            } else {
                this._dataSelection.toggleColumn(column);
            }
        }
    }
}

