/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.metamodel.MetaModelHelper;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;

public class TableDataSelectionComboBox
extends JComboBox
implements Observer {
    private static final long serialVersionUID = -1710922243398760674L;
    private ColumnSelection _dataSelection;
    private Map<String, Table> _tables;

    public TableDataSelectionComboBox(ColumnSelection dataSelection) {
        this._dataSelection = dataSelection;
        this._dataSelection.addObserver(this);
        this.setEditable(false);
        this.updateTables();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof ColumnSelection) {
            this.updateTables();
        }
    }

    private void updateTables() {
        this.removeAllItems();
        this._tables = new HashMap<String, Table>();
        List<Column> columns = this._dataSelection.getColumns();
        Table[] tables = MetaModelHelper.getTables(columns);
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            String tableName = table.getName();
            this._tables.put(tableName, table);
            this.addItem(tableName);
        }
    }

    public Table getSelectedTable() {
        String tableName = (String)this.getSelectedItem();
        return this._tables.get(tableName);
    }

    public void close() {
        this._dataSelection.deleteObserver(this);
    }
}

