/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.windows;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.panels.ComparatorSelectionPanel;
import dk.eobjects.datacleaner.gui.widgets.OpenDatabaseButton;
import dk.eobjects.datacleaner.gui.widgets.OpenFileButton;
import dk.eobjects.datacleaner.gui.widgets.SchemaTree;
import dk.eobjects.datacleaner.gui.widgets.SchemaTreeMouseListener;
import dk.eobjects.datacleaner.gui.windows.AbstractWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class ComparatorWindow
extends AbstractWindow {
    private DataContextSelection _leftDataContextSelection;
    private ColumnSelection _leftColumnSelection;
    private DataContextSelection _rightDataContextSelection;
    private ColumnSelection _rightColumnSelection;

    public ComparatorWindow() {
        this._panel.setLayout(new BorderLayout());
        this._leftDataContextSelection = new DataContextSelection();
        this._leftColumnSelection = new ColumnSelection(this._leftDataContextSelection);
        JPanel leftPanel = this.createSchemaPanel(this._leftDataContextSelection, this._leftColumnSelection);
        leftPanel.setName("left");
        this._panel.add((Component)leftPanel, "West");
        this._rightDataContextSelection = new DataContextSelection();
        this._rightColumnSelection = new ColumnSelection(this._rightDataContextSelection);
        JPanel rightPanel = this.createSchemaPanel(this._rightDataContextSelection, this._rightColumnSelection);
        rightPanel.setName("right");
        this._panel.add((Component)rightPanel, "East");
        ComparatorSelectionPanel comparisonSelectionPanel = new ComparatorSelectionPanel(this._leftDataContextSelection, this._rightDataContextSelection, this._leftColumnSelection, this._rightColumnSelection);
        comparisonSelectionPanel.setName("center");
        this._panel.add((Component)comparisonSelectionPanel, "Center");
    }

    private JPanel createSchemaPanel(DataContextSelection dataContextSelection, ColumnSelection dataSelection) {
        JPanel panel = new JPanel(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.add(new OpenDatabaseButton(dataContextSelection));
        toolbar.add(new OpenFileButton(dataContextSelection));
        panel.add((Component)toolbar, "North");
        SchemaTree schemaTree = new SchemaTree(dataContextSelection);
        schemaTree.addMouseListener(new SchemaTreeMouseListener(schemaTree, dataContextSelection, dataSelection));
        JScrollPane scrollSchemaTree = new JScrollPane(schemaTree);
        panel.add((Component)scrollSchemaTree, "Center");
        return panel;
    }

    public ImageIcon getFrameIcon() {
        return GuiHelper.getImageIcon("images/window_compare.png");
    }

    public String getTitle() {
        return "Comparator";
    }
}

