/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.windows;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.panels.ColumnSelectionPanel;
import dk.eobjects.datacleaner.gui.panels.MetadataPanel;
import dk.eobjects.datacleaner.gui.widgets.AddValidationRuleButton;
import dk.eobjects.datacleaner.gui.widgets.OpenDatabaseButton;
import dk.eobjects.datacleaner.gui.widgets.OpenFileButton;
import dk.eobjects.datacleaner.gui.widgets.RunValidationButton;
import dk.eobjects.datacleaner.gui.widgets.SchemaTree;
import dk.eobjects.datacleaner.gui.widgets.SchemaTreeMouseListener;
import dk.eobjects.datacleaner.gui.windows.AbstractWindow;
import dk.eobjects.thirdparty.tabs.CloseableTabbedPane;
import dk.eobjects.thirdparty.tabs.TabCloseEvent;
import dk.eobjects.thirdparty.tabs.TabCloseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class ValidatorWindow
extends AbstractWindow {
    private final DataContextSelection _dataContextSelection = new DataContextSelection();
    private final ColumnSelection _columnSelection = new ColumnSelection(this._dataContextSelection);
    private CloseableTabbedPane _tabbedPane = new CloseableTabbedPane();

    public ValidatorWindow() {
        this._tabbedPane.addTabCloseListener(new TabCloseListener(){

            public void tabClosed(TabCloseEvent event) {
                int tabIndex = event.getClosedTab();
                Component component = ValidatorWindow.this._tabbedPane.getComponent(tabIndex);
                if (component instanceof JScrollPane) {
                    component = ((JScrollPane)component).getViewport().getComponent(0);
                }
                ValidatorWindow.this._tabbedPane.remove(tabIndex);
                if (component instanceof Closeable) {
                    try {
                        ((Closeable)((Object)component)).close();
                    }
                    catch (IOException e) {
                        ValidatorWindow.this._log.info((Object)("Error closing tab: " + e.getMessage()));
                        ValidatorWindow.this._log.error((Object)e);
                    }
                }
                System.gc();
            }
        });
        this._panel.setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.add(new OpenDatabaseButton(this._dataContextSelection));
        toolbar.add(new OpenFileButton(this._dataContextSelection));
        toolbar.add(new JSeparator(1));
        toolbar.add(new AddValidationRuleButton(this._columnSelection, this._tabbedPane));
        toolbar.add(new RunValidationButton(this._dataContextSelection, this._columnSelection, this._tabbedPane));
        this._panel.add((Component)toolbar, "North");
        JSplitPane splitPane = new JSplitPane(1);
        SchemaTree schemaTree = new SchemaTree(this._dataContextSelection);
        schemaTree.addMouseListener(new SchemaTreeMouseListener(schemaTree, this._dataContextSelection, this._columnSelection));
        splitPane.add(new JScrollPane(schemaTree));
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(this._dataContextSelection, this._columnSelection);
        MetadataPanel metadataPanel = new MetadataPanel(this._columnSelection);
        this._tabbedPane.addTab("Data selection", GuiHelper.getImageIcon("images/tab_data_selection.png"), columnSelectionPanel);
        this._tabbedPane.addTab("Metadata", GuiHelper.getImageIcon("images/tab_metadata.png"), metadataPanel);
        this._tabbedPane.setUnclosableTab(0);
        this._tabbedPane.setUnclosableTab(1);
        splitPane.add(this._tabbedPane);
        this._panel.add((Component)splitPane, "Center");
    }

    public ImageIcon getFrameIcon() {
        return GuiHelper.getImageIcon("images/window_validate.png");
    }

    public String getTitle() {
        return "Validator";
    }
}

