/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.thirdparty.tabs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.thirdparty.tabs.CloseableTabbedPaneUI;
import dk.eobjects.thirdparty.tabs.TabCloseEvent;
import dk.eobjects.thirdparty.tabs.TabCloseListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -411551524171347329L;
    private static Log _log = LogFactory.getLog(CloseableTabbedPane.class);
    private Vector<TabCloseListener> _closeListener = new Vector();
    private volatile CloseableTabbedPaneUI _ui;
    private Vector<Integer> _unclosables = new Vector();

    public void setUnclosableTab(int val) {
        if (this._unclosables.contains(val)) {
            return;
        }
        this._unclosables.addElement(val);
    }

    public void setClosableTab(int val) {
        this._unclosables.removeElement(val);
    }

    public void addTabCloseListener(TabCloseListener lis) {
        this._closeListener.addElement(lis);
    }

    public void removeTabCloseListener(TabCloseListener lis) {
        this._closeListener.removeElement(lis);
    }

    public CloseableTabbedPane() {
        this(1);
    }

    public CloseableTabbedPane(int placement) {
        this(placement, 0);
    }

    public CloseableTabbedPane(int placement, int layout) {
        super(placement, layout);
        this._ui = new CloseableTabbedPaneUI(this);
        this.setUI(this._ui);
        ImageIcon closeIcon = GuiHelper.getImageIcon("images/tab_close.png");
        ImageIcon closeHoverIcon = GuiHelper.getImageIcon("images/tab_close_hover.png");
        this.setIcons(closeIcon, closeHoverIcon);
    }

    public void setIcons(ImageIcon normalIcon, ImageIcon hoverIcon) {
        this._ui.setCloseIcons(normalIcon, hoverIcon);
    }

    public void closeTab(int tab) {
        _log.debug((Object)("Closing tab: " + tab + ", listeners: " + this._closeListener));
        if (this._closeListener.size() == 0) {
            return;
        }
        TabCloseEvent ev = new TabCloseEvent(this, tab);
        for (TabCloseListener l : this._closeListener) {
            try {
                _log.debug((Object)("Sending close to: " + l));
                l.tabClosed(ev);
            }
            catch (Exception ex) {
                _log.error((Object)ex.toString(), (Throwable)ex);
            }
        }
    }

    public void setCloseWidth(int width) {
        this._ui.setCloseWidth(width);
        this.repaint();
    }

    public Vector<Integer> getUnclosables() {
        return this._unclosables;
    }
}

