/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.thirdparty.tabs;

import dk.eobjects.thirdparty.tabs.CloseableTabbedPane;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class CloseableTabbedPaneUI
extends BasicTabbedPaneUI {
    private CloseableTabbedPane _pane;
    private ImageIcon _closeIconUp;
    private ImageIcon _closeIconDown;
    private volatile int _closeIdx = -1;
    private volatile int _closeWidth = 22;
    private volatile int _closeOverIdx = -1;
    volatile int lastTabHeight = 0;

    public CloseableTabbedPaneUI(CloseableTabbedPane pane) {
        this._pane = pane;
    }

    public void setCloseIcons(ImageIcon closeIconUp, ImageIcon closeIconDown) {
        this._closeIconUp = closeIconUp;
        this._closeIconDown = closeIconDown;
    }

    private Rectangle closeRectFor(int tabIndex) {
        int cw = this.closeWidth();
        return new Rectangle(this.rects[tabIndex].x + this.rects[tabIndex].width - cw - cw / 2, this.rects[tabIndex].y + (this.lastTabHeight - (this._closeIconUp == null ? cw : this._closeIconUp.getIconHeight())) / 2, cw, cw + 1);
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int w = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        if (!this._pane.getUnclosables().contains(tabIndex)) {
            w += this.closeWidth() + this.closeWidth() / 2;
        }
        return w;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int v) {
        int h = super.calculateTabHeight(tabPlacement, tabIndex, v);
        if (!this._pane.getUnclosables().contains(tabIndex)) {
            h = Math.max(h, (this._closeIconUp != null ? this._closeIconUp.getIconHeight() : this._closeWidth) + 6);
        }
        this.lastTabHeight = h;
        return this.lastTabHeight;
    }

    public int closeWidth() {
        return this._closeIconUp != null ? this._closeIconUp.getIconWidth() : this._closeWidth;
    }

    int closeDownIdx() {
        return this._closeIdx;
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Rectangle r = new Rectangle(textRect);
        if (!this._pane.getUnclosables().contains(tabIndex)) {
            r.x -= this._closeWidth - this._closeWidth / 2;
        }
        super.paintText(g, tabPlacement, font, metrics, tabIndex, title, r, isSelected);
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        Rectangle r = new Rectangle(iconRect);
        if (!this._pane.getUnclosables().contains(tabIndex)) {
            r.x -= this._closeWidth - this._closeWidth / 2;
        }
        super.paintIcon(g, tabPlacement, tabIndex, icon, r, isSelected);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        if (this._pane.getUnclosables().contains(tabIndex)) {
            return;
        }
        int ov = this.closeWidth();
        if (this._closeIconUp != null) {
            g.drawImage(this.closeDownIdx() != tabIndex ? this._closeIconUp.getImage() : this._closeIconDown.getImage(), x + w - ov - ov / 2, y + (h - this._closeIconUp.getIconHeight()) / 2, this._pane);
        } else {
            g.setColor(this._closeOverIdx == tabIndex && this.closeDownIdx() == -1 ? new Color(220, 230, 255) : Color.gray.brighter());
            g.fill3DRect(x + w - ov - ov / 2, y + (h - ov) / 2, ov, ov, this.closeDownIdx() != tabIndex);
            g.draw3DRect(x + w - ov - ov / 2 - 1, y + (h - ov) / 2, ov + 1, ov + 1, this.closeDownIdx() != tabIndex);
            g.setColor(Color.black);
            g.drawLine(x + w - ov / 2 - 0, y + (h - ov) / 2 + 0, x + w - ov - ov / 2 + 2, y + (h - ov) / 2 + ov - 2);
            g.drawLine(x + w - ov - ov / 2 + 2, y + (h - ov) / 2 + 2, x + w - ov / 2 - 2, y + (h - ov) / 2 + ov - 2);
        }
    }

    protected void installListeners() {
        super.installListeners();
        CloseableTabbedPaneMouseListener mlis = new CloseableTabbedPaneMouseListener();
        this.tabPane.addMouseListener(mlis);
        this.tabPane.addMouseMotionListener(mlis);
    }

    public void setCloseWidth(int width) {
        this._closeWidth = width;
    }

    public class CloseableTabbedPaneMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseReleased(MouseEvent e) {
            CloseableTabbedPaneUI.this._closeIdx = -1;
            CloseableTabbedPaneUI.this.tabPane.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (!CloseableTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            int tabIndex = CloseableTabbedPaneUI.this.tabForCoordinate(CloseableTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex == -1) {
                return;
            }
            if (CloseableTabbedPaneUI.this._pane.getUnclosables().contains(tabIndex)) {
                return;
            }
            Rectangle r = CloseableTabbedPaneUI.this.closeRectFor(tabIndex);
            if (r.contains(new Point(e.getX(), e.getY()))) {
                CloseableTabbedPaneUI.this._pane.closeTab(tabIndex);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!CloseableTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            int tabIndex = CloseableTabbedPaneUI.this.tabForCoordinate(CloseableTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex == -1) {
                return;
            }
            if (CloseableTabbedPaneUI.this._pane.getUnclosables().contains(tabIndex)) {
                return;
            }
            Rectangle r = CloseableTabbedPaneUI.this.closeRectFor(tabIndex);
            if (r.contains(new Point(e.getX(), e.getY()))) {
                CloseableTabbedPaneUI.this._closeIdx = tabIndex;
            } else {
                CloseableTabbedPaneUI.this._closeIdx = -1;
            }
            CloseableTabbedPaneUI.this.tabPane.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
            this.mousePressed(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (CloseableTabbedPaneUI.this.tabPane == null || !CloseableTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = CloseableTabbedPaneUI.this.tabForCoordinate(CloseableTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex == -1) {
                return;
            }
            if (CloseableTabbedPaneUI.this._pane.getUnclosables().contains(tabIndex)) {
                return;
            }
            Rectangle r = CloseableTabbedPaneUI.this.closeRectFor(tabIndex);
            if (r.contains(new Point(e.getX(), e.getY()))) {
                CloseableTabbedPaneUI.this._closeIdx = tabIndex;
            } else {
                CloseableTabbedPaneUI.this._closeIdx = -1;
            }
            CloseableTabbedPaneUI.this.tabPane.repaint();
        }
    }
}

