/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.thirdparty.textarea.tokermarkers;

import dk.eobjects.thirdparty.textarea.KeywordMap;
import dk.eobjects.thirdparty.textarea.SyntaxUtilities;
import dk.eobjects.thirdparty.textarea.tokermarkers.TokenMarker;
import javax.swing.text.Segment;

public class PythonTokenMarker
extends TokenMarker {
    private static final byte TRIPLEQUOTE1 = 100;
    private static final byte TRIPLEQUOTE2 = 126;
    private static KeywordMap pyKeywords;
    private KeywordMap keywords = PythonTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block16: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            this.lastOffset = this.lastKeyword = length;
                            break block16;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = SyntaxUtilities.regionMatches(false, line, i1, "\"\"") ? (byte)100 : (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = SyntaxUtilities.regionMatches(false, line, i1, "''") ? (byte)126 : (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block16;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block16;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block16;
                    }
                    if (c != '\"') continue block16;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block16;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block16;
                    }
                    if (c != '\'') continue block16;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block16;
                }
                case 100: {
                    if (backslash) {
                        backslash = false;
                        continue block16;
                    }
                    if (!SyntaxUtilities.regionMatches(false, line, i, "\"\"\"")) continue block16;
                    this.addToken((i += 4) - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i;
                    continue block16;
                }
                case 126: {
                    if (backslash) {
                        backslash = false;
                        continue block16;
                    }
                    if (!SyntaxUtilities.regionMatches(false, line, i, "'''")) continue block16;
                    this.addToken((i += 4) - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i;
                    continue block16;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        switch (token) {
            case 100: 
            case 126: {
                this.addToken(length - this.lastOffset, (byte)3);
                break;
            }
            case 0: {
                this.doKeyword(line, length, '\u0000');
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (pyKeywords == null) {
            pyKeywords = new KeywordMap(false);
            pyKeywords.add("and", (byte)8);
            pyKeywords.add("not", (byte)8);
            pyKeywords.add("or", (byte)8);
            pyKeywords.add("if", (byte)6);
            pyKeywords.add("for", (byte)6);
            pyKeywords.add("assert", (byte)6);
            pyKeywords.add("break", (byte)6);
            pyKeywords.add("continue", (byte)6);
            pyKeywords.add("elif", (byte)6);
            pyKeywords.add("else", (byte)6);
            pyKeywords.add("except", (byte)6);
            pyKeywords.add("exec", (byte)6);
            pyKeywords.add("finally", (byte)6);
            pyKeywords.add("raise", (byte)6);
            pyKeywords.add("return", (byte)6);
            pyKeywords.add("try", (byte)6);
            pyKeywords.add("while", (byte)6);
            pyKeywords.add("def", (byte)7);
            pyKeywords.add("class", (byte)7);
            pyKeywords.add("del", (byte)7);
            pyKeywords.add("from", (byte)7);
            pyKeywords.add("global", (byte)7);
            pyKeywords.add("import", (byte)7);
            pyKeywords.add("in", (byte)7);
            pyKeywords.add("is", (byte)7);
            pyKeywords.add("lambda", (byte)7);
            pyKeywords.add("pass", (byte)7);
            pyKeywords.add("print", (byte)7);
        }
        return pyKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

