/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui;

import dk.eobjects.datacleaner.gui.dialogs.NewTaskDialog;
import dk.eobjects.datacleaner.gui.model.DatabaseDriver;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import dk.eobjects.datacleaner.gui.windows.MainWindow;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataCleanerGui {
    public static final int EXIT_CODE_NORMAL_EXIT = 0;
    public static final int EXIT_CODE_COULD_NOT_OPEN_CONFIGURATION_FILE = 15;
    private static Log _log = LogFactory.getLog(DataCleanerGui.class);
    private static MainWindow _mainWindow;

    public static void main(String[] args) throws Exception {
        _log.info((Object)"DataCleaner-gui starting up.");
        GuiConfiguration.initialize();
        GuiSettings.initialize();
        DataCleanerGui.loadDrivers();
        _mainWindow = new MainWindow();
        NewTaskDialog dialog = new NewTaskDialog();
        dialog.setVisible(true);
    }

    private static void loadDrivers() {
        Collection<DatabaseDriver> databaseDrivers = GuiSettings.getSettings().getDatabaseDrivers();
        for (DatabaseDriver databaseDriver : databaseDrivers) {
            try {
                databaseDriver.loadDriver();
            }
            catch (Exception e) {
                _log.error((Object)("Could not load database driver: " + databaseDriver), (Throwable)e);
            }
        }
        databaseDrivers = GuiConfiguration.getBeansOfClass(DatabaseDriver.class);
        for (DatabaseDriver databaseDriver : databaseDrivers) {
            try {
                databaseDriver.loadDriver();
            }
            catch (Exception e) {
                _log.error((Object)("Could not load database driver: " + databaseDriver), (Throwable)e);
            }
        }
    }

    public static MainWindow getMainWindow() {
        return _mainWindow;
    }

    public static void setMainWindow(MainWindow window) {
        _mainWindow = window;
    }
}

