/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui;

import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorLevel;

public class GuiHelper {
    private static Log _log = LogFactory.getLog(GuiHelper.class);
    public static final Font HEADER_FONT = new Font("Sans", 1, 15);
    public static final Font MONOSPACE_FONT = new Font("Monospaced", 0, 14);
    public static final Highlighter LIBERELLO_HIGHLIGHTER = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.BEIGE, (Color)HighlighterFactory.FLORAL_WHITE);

    public static void confirmExit() {
        int feedback = JOptionPane.showConfirmDialog(null, "Are you sure you want to exit DataCleaner?", "Exit", 0);
        if (feedback == 0) {
            _log.info((Object)"DataCleaner-gui shutting down.");
            System.exit(0);
        }
    }

    public static void centerOnScreen(Component component) {
        Dimension paneSize = component.getSize();
        Dimension screenSize = component.getToolkit().getScreenSize();
        component.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    public static String getLicenceText() {
        try {
            return GuiHelper.getResourceContent("licence.txt");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getCreditsText() {
        try {
            return GuiHelper.getResourceContent("credits.txt");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getChangelogText() {
        try {
            return GuiHelper.getResourceContent("changelog.txt");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getResourceContent(String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(filename), "UTF8"));
        StringBuilder sb = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            sb.append(line);
            line = reader.readLine();
            if (line == null) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void showErrorMessage(String shortMessage, String detailedMessage, Throwable exception) {
        JXErrorPane.setDefaultLocale((Locale)Locale.ENGLISH);
        JXErrorPane errorPane = new JXErrorPane();
        ErrorInfo info = new ErrorInfo(shortMessage, detailedMessage, null, "error", exception, ErrorLevel.SEVERE, null);
        errorPane.setErrorInfo(info);
        JDialog dialog = JXErrorPane.createDialog((Component)DataCleanerGui.getMainWindow().getFrame(), (JXErrorPane)errorPane);
        dialog.setTitle(shortMessage);
        dialog.setVisible(true);
    }

    public static ImageIcon getImageIcon(String imagePath) {
        return new ImageIcon(GuiHelper.getImage(imagePath));
    }

    public static Image getImage(String imagePath) {
        try {
            return ImageIO.read(ClassLoader.getSystemResource(imagePath));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getLabelForTable(Table table) {
        return table.getName() + ".*";
    }

    public static String getLabelForColumn(Column column) {
        Table table = column.getTable();
        return table.getName() + "." + column.getName();
    }

    public static Column getColumnByLabel(ColumnSelection columnSelection, String label) {
        List<Column> columns = columnSelection.getColumns();
        Object[] tables = ReflectionHelper.getProperties(columns, (String)"table");
        for (int i = 0; i < tables.length; ++i) {
            Column column;
            String columnName;
            String tablePrefix = ((Table)tables[i]).getName() + ".";
            if (!label.startsWith(tablePrefix) || !(columnName = label.substring(tablePrefix.length())).equals((column = columns.get(i)).getName())) continue;
            return column;
        }
        return null;
    }

    public static void addComponentAligned(Container container, JComponent component) {
        component.setAlignmentX(0.0f);
        component.setAlignmentY(0.0f);
        container.add(component);
    }

    public static void addToGridBag(JComponent comp, JPanel panel, int gridx, int gridy, int width, int height, int anchor) {
        LayoutManager layout = panel.getLayout();
        if (!(layout instanceof GridBagLayout)) {
            layout = new GridBagLayout();
            panel.setLayout(layout);
        }
        GridBagLayout gridBagLayout = (GridBagLayout)layout;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.anchor = anchor;
        constraints.fill = 2;
        constraints.ipadx = 4;
        constraints.ipady = 4;
        gridBagLayout.addLayoutComponent(comp, constraints);
        panel.add(comp);
    }

    public static void addToGridBag(JComponent comp, JPanel panel, int gridx, int gridy, int width, int height) {
        GuiHelper.addToGridBag(comp, panel, gridx, gridy, width, height, 17);
    }

    public static void addToGridBag(JComponent comp, JPanel panel, int gridx, int gridy) {
        GuiHelper.addToGridBag(comp, panel, gridx, gridy, 1, 1);
    }

    public static void addToGridBag(JComponent comp, JPanel panel, int gridx, int gridy, int anchor) {
        GuiHelper.addToGridBag(comp, panel, gridx, gridy, 1, 1, anchor);
    }
}

