/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public abstract class BanneredDialog
extends JDialog {
    private static final long serialVersionUID = 6803739986587937688L;

    public BanneredDialog() {
        this(400, 500);
    }

    public BanneredDialog(int width, int height) {
        super(DataCleanerGui.getMainWindow().getFrame());
        this.setTitle(this.getDialogTitle());
        this.setLayout(new BorderLayout());
        this.setSize(width, height);
        this.setResizable(true);
        this.add(this.getBanner(), "North");
        this.add(this.getContent(), "Center");
        GuiHelper.centerOnScreen(this);
    }

    protected Component getBanner() {
        JPanel panel = new JPanel(new FlowLayout(1, 0, 0)){
            private static final long serialVersionUID = -9014625499488304280L;

            protected void paintComponent(Graphics g) {
                ImageIcon backgroundIcon = GuiHelper.getImageIcon("images/dialog_banner_bg.png");
                if (this.isOpaque()) {
                    super.paintComponent(g);
                }
                Dimension size = this.getSize();
                for (int x = 0; x < size.width; x += backgroundIcon.getIconWidth()) {
                    backgroundIcon.paintIcon(this, g, x, 0);
                }
            }
        };
        panel.setBorder(new MatteBorder(0, 0, 1, 0, Color.BLACK));
        ImageIcon logo = GuiHelper.getImageIcon("images/dialog_banner.png");
        JLabel label = new JLabel(logo);
        panel.add(label, 0, 0);
        return panel;
    }

    protected abstract Component getContent();

    protected abstract String getDialogTitle();
}

