/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.CsvConfigurationDialog;
import dk.eobjects.datacleaner.gui.model.CombinationFilter;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.model.ExtensionFilter;
import java.io.File;
import javax.swing.JFileChooser;

public class DataFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 3798179789539560724L;
    private DataContextSelection _dataContextSelection;
    public static final String EXTENSION_COMMA_SEPARATED = "csv";
    public static final String EXTENSION_TAB_SEPARATED = "tsv";
    public static final String EXTENSION_XLS = "xls";
    private static final String EXTENSION_ODB = "odb";
    private static final String EXTENSION_XML = "xml";

    public DataFileChooser(DataContextSelection dataContextSelection) {
        this._dataContextSelection = dataContextSelection;
        ExtensionFilter csvFilter = new ExtensionFilter("Comma-separated file (.csv)", EXTENSION_COMMA_SEPARATED);
        ExtensionFilter tsvFilter = new ExtensionFilter("Tab-separated file (.tsv)", EXTENSION_TAB_SEPARATED);
        ExtensionFilter excelFilter = new ExtensionFilter("Excel File (.xls)", EXTENSION_XLS);
        ExtensionFilter odbFilter = new ExtensionFilter("OpenOffice.org database (.odb)", EXTENSION_ODB);
        ExtensionFilter xmlFilter = new ExtensionFilter("Extensible Markup Language (.xml)", EXTENSION_XML);
        CombinationFilter combinationFilter = new CombinationFilter(csvFilter, tsvFilter, excelFilter, odbFilter, xmlFilter);
        this.addChoosableFileFilter(combinationFilter);
        this.addChoosableFileFilter(csvFilter);
        this.addChoosableFileFilter(tsvFilter);
        this.addChoosableFileFilter(excelFilter);
        this.addChoosableFileFilter(odbFilter);
        this.addChoosableFileFilter(xmlFilter);
        this.setFileFilter(combinationFilter);
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        GuiHelper.centerOnScreen(this);
    }

    public void approveSelection() {
        super.approveSelection();
        try {
            File file = this.getSelectedFile();
            String fileExtension = ExtensionFilter.getExtention(file);
            if (fileExtension.equalsIgnoreCase(EXTENSION_COMMA_SEPARATED) || fileExtension.equalsIgnoreCase(EXTENSION_TAB_SEPARATED)) {
                CsvConfigurationDialog dialog = new CsvConfigurationDialog(this._dataContextSelection, file);
                dialog.setVisible(true);
            } else {
                this._dataContextSelection.selectFile(file);
            }
        }
        catch (Exception e) {
            GuiHelper.showErrorMessage("Could not read data from file!", "An error occurred while reading from the file.", e);
        }
    }
}

