/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import dk.eobjects.datacleaner.gui.model.DatabaseDriver;
import dk.eobjects.datacleaner.gui.model.ExtensionFilter;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import dk.eobjects.datacleaner.gui.widgets.AutoCompleteComboBox;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DatabaseDriverDialog
extends BanneredDialog {
    private static final long serialVersionUID = -7450893693170647726L;
    private static final String[] COMMON_DRIVER_NAMES = new String[]{"org.postgresql.Driver", "org.firebirdsql.jdbc.FBDriver", "org.apache.derby.jdbc.ClientDriver", "oracle.jdbc.driver.OracleDriver", "com.mysql.jdbc.Driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver"};
    private JTextField _filenameField;
    private AutoCompleteComboBox _driverClassField;
    private File _file;

    public static ActionListener getActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                ExtensionFilter filter = new ExtensionFilter("Java class archive (.jar)", "jar");
                fileChooser.setFileFilter(filter);
                GuiHelper.centerOnScreen(fileChooser);
                if (fileChooser.showOpenDialog(null) == 0) {
                    File file = fileChooser.getSelectedFile();
                    DatabaseDriverDialog dialog = new DatabaseDriverDialog(file);
                    dialog.setVisible(true);
                }
            }
        };
    }

    public DatabaseDriverDialog(File file) {
        JTextArea aboutDatabaseDrivers = new JTextArea();
        aboutDatabaseDrivers.setEditable(false);
        aboutDatabaseDrivers.setLineWrap(true);
        aboutDatabaseDrivers.setWrapStyleWord(true);
        aboutDatabaseDrivers.setText("Database drivers are java classes that enable programs to connect to a database. To add a database driver you have to obtain the driver file as well as the class name from you database vendor.");
        this.add((Component)aboutDatabaseDrivers, "South");
        this._file = file;
        this._filenameField.setText(file.getAbsolutePath());
    }

    protected Component getContent() {
        JPanel panel = new JPanel();
        JLabel header = new JLabel("Database driver");
        header.setFont(GuiHelper.HEADER_FONT);
        GuiHelper.addToGridBag(header, panel, 0, 0, 2, 1);
        this._filenameField = new JTextField(30);
        this._filenameField.setEditable(false);
        GuiHelper.addToGridBag(new JLabel("Filename:"), panel, 0, 1);
        GuiHelper.addToGridBag(this._filenameField, panel, 1, 1);
        GuiHelper.addToGridBag(new JLabel("Driver class:"), panel, 0, 2);
        Object[] items = COMMON_DRIVER_NAMES;
        this._driverClassField = new AutoCompleteComboBox(items);
        this._driverClassField.setName("driverClassField");
        GuiHelper.addToGridBag(this._driverClassField, panel, 1, 2);
        JButton saveButton = new JButton("Test and save database driver", GuiHelper.getImageIcon("images/toolbar_database.png"));
        saveButton.setName("saveButton");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String driverClass = DatabaseDriverDialog.this._driverClassField.getSelectedItem().toString().trim();
                DatabaseDriver databaseDriver = new DatabaseDriver(DatabaseDriverDialog.this._file, driverClass);
                GuiSettings settings = GuiSettings.getSettings();
                Object[] driverClasses = ReflectionHelper.getProperties((Object[])settings.getDatabaseDrivers().toArray(), (String)"driverClass");
                boolean unique = true;
                for (int i = 0; i < driverClasses.length && unique; ++i) {
                    if (!driverClass.equals(driverClasses[i])) continue;
                    unique = false;
                    GuiHelper.showErrorMessage("Driver class already registered", "The driver class '" + driverClass + "' is already registered in your database driver catalog.", null);
                }
                if (unique) {
                    try {
                        databaseDriver.loadDriver();
                        settings.getDatabaseDrivers().add(databaseDriver);
                        GuiSettings.saveSettings(settings);
                        DatabaseDriverDialog.this.dispose();
                    }
                    catch (Exception e) {
                        GuiHelper.showErrorMessage("Could not load driver", "An error occurred while loading the database driver", e);
                    }
                }
            }
        });
        GuiHelper.addToGridBag(saveButton, panel, 1, 3);
        return panel;
    }

    protected String getDialogTitle() {
        return "Database driver";
    }
}

