/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.catalog.NamedRegex;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import dk.eobjects.datacleaner.gui.dialogs.TestRegexDialog;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NamedRegexDialog
extends BanneredDialog {
    private static final long serialVersionUID = -2434857404861203054L;
    private NamedRegex _regex;
    private JTextField _nameField;
    private JTextField _expressionField;
    private JButton _testButton;

    public NamedRegexDialog(NamedRegex regex) {
        super(400, 350);
        JTextArea aboutRegexes = new JTextArea();
        aboutRegexes.setEditable(false);
        aboutRegexes.setLineWrap(true);
        aboutRegexes.setWrapStyleWord(true);
        aboutRegexes.setText("A regex (regular expression) is a concise and flexible means for identifying strings of text of interest, such as particular characters, words, or patterns of characters. The registered regexes can be used to identify certain types of strings and validate their pattern-correctness.");
        this.add((Component)aboutRegexes, "South");
        this._regex = regex;
        this.updateDialog();
    }

    private void updateDialog() {
        if (this._regex != null) {
            this._nameField.setText(this._regex.getName());
            this._expressionField.setText(this._regex.getExpression());
        }
    }

    protected Component getContent() {
        JPanel panel = new JPanel();
        JLabel header = new JLabel("Regex");
        header.setFont(GuiHelper.HEADER_FONT);
        GuiHelper.addToGridBag(header, panel, 0, 0, 2, 1);
        GuiHelper.addToGridBag(new JLabel("Regex name:"), panel, 0, 1);
        this._nameField = new JTextField();
        this._nameField.setPreferredSize(new Dimension(200, 20));
        GuiHelper.addToGridBag(this._nameField, panel, 1, 1);
        GuiHelper.addToGridBag(new JLabel("Expression:"), panel, 0, 2);
        this._expressionField = new JTextField();
        this._expressionField.setPreferredSize(new Dimension(200, 20));
        GuiHelper.addToGridBag(this._expressionField, panel, 1, 2);
        this._testButton = new JButton("Test it");
        this._testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestRegexDialog dialog = new TestRegexDialog(NamedRegexDialog.this._expressionField.getText());
                dialog.setVisible(true);
            }
        });
        GuiHelper.addToGridBag(this._testButton, panel, 2, 2);
        JButton saveButton = new JButton("Save regex", GuiHelper.getImageIcon("images/regexes.png"));
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = NamedRegexDialog.this._nameField.getText();
                String expression = NamedRegexDialog.this._expressionField.getText();
                if (name.length() > 2) {
                    GuiSettings settings = GuiSettings.getSettings();
                    if (NamedRegexDialog.this._regex == null) {
                        NamedRegexDialog.this._regex = new NamedRegex(name, expression);
                        settings.getRegexes().add(NamedRegexDialog.this._regex);
                    } else {
                        NamedRegexDialog.this._regex.setName(name);
                        NamedRegexDialog.this._regex.setExpression(expression);
                    }
                    GuiSettings.saveSettings(settings);
                    NamedRegexDialog.this.dispose();
                } else {
                    GuiHelper.showErrorMessage("Regex name required", "Please provide a name of minimum 3 characters for your regex.", new IllegalArgumentException(name));
                }
            }
        });
        GuiHelper.addToGridBag(saveButton, panel, 1, 3);
        return panel;
    }

    protected String getDialogTitle() {
        return "Regex";
    }
}

