/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import dk.eobjects.datacleaner.gui.widgets.AddWindowButton;
import dk.eobjects.datacleaner.gui.widgets.OpenFileActionListener;
import dk.eobjects.datacleaner.gui.windows.ComparatorWindow;
import dk.eobjects.datacleaner.gui.windows.ProfilerWindow;
import dk.eobjects.datacleaner.gui.windows.ValidatorWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class NewTaskDialog
extends BanneredDialog {
    private static final long serialVersionUID = -8480059695682450837L;
    private static final Font DESC_FONT = new Font("Arial", 0, 12);
    private JPanel _panel;

    public NewTaskDialog() {
        super(400, 490);
    }

    protected Component getContent() {
        this._panel = new JPanel(null);
        JTextArea profileDesc = this.createDescLabel("Gain insight into the structure and content of your data. With a data profile you will know where to improve quality.");
        JTextArea validateDesc = this.createDescLabel("Create validation rules and test them on your data to ensure the continous integrity of your data's quality.");
        JTextArea compareDesc = this.createDescLabel("Compare columns, tables and schemas with each others! Find out if what you think is consistent really is! Please wait for DataCleaner 1.1 for this feature.");
        JTextArea openFileDesc = this.createDescLabel("... or you can load your profiling or validation work from a saved file.");
        this.addToPanel(new JLabel("Welcome to DataCleaner. What do you want to do?"), 10, 5, 400, 20);
        this.addToPanel(this.createHeaderLabel("Profile"), 90, 30, 290, 20);
        this.addToPanel(profileDesc, 90, 50, 290, 70);
        this.addToPanel(this.createHeaderLabel("Validate"), 90, 130, 290, 20);
        this.addToPanel(validateDesc, 90, 150, 290, 70);
        this.addToPanel(this.createHeaderLabel("Compare"), 90, 230, 290, 20);
        this.addToPanel(compareDesc, 90, 250, 290, 70);
        this.addToPanel(openFileDesc, 45, 326, 250, 80);
        AddWindowButton profilerButton = new AddWindowButton(ProfilerWindow.class, GuiHelper.getImageIcon("images/task_profile.png"), this, "Profile");
        this.addToPanel(profilerButton, 10, 30, 64, 64);
        AddWindowButton validatorButton = new AddWindowButton(ValidatorWindow.class, GuiHelper.getImageIcon("images/task_validate.png"), this, "Validate");
        this.addToPanel(validatorButton, 10, 130, 64, 64);
        AddWindowButton comparatorButton = new AddWindowButton(ComparatorWindow.class, GuiHelper.getImageIcon("images/task_compare.png"), this, "Compare");
        this.addToPanel(comparatorButton, 10, 230, 64, 64);
        JButton openFileButton = new JButton(GuiHelper.getImageIcon("images/toolbar_open.png"));
        openFileButton.addActionListener(new OpenFileActionListener());
        openFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewTaskDialog.this.dispose();
            }
        });
        openFileButton.setToolTipText("Open file");
        this.addToPanel(openFileButton, 10, 330, 26, 26);
        return this._panel;
    }

    protected String getDialogTitle() {
        return "Select a DataCleaner task";
    }

    private JTextArea createDescLabel(String text) {
        JTextArea textArea = new JTextArea(text);
        Dimension dimension = new Dimension(320, 44);
        textArea.setPreferredSize(dimension);
        textArea.setSize(dimension);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setBackground(this._panel.getBackground());
        textArea.setFont(DESC_FONT);
        return textArea;
    }

    private JLabel createHeaderLabel(String text) {
        JLabel label = new JLabel(text);
        Dimension dimension = new Dimension(320, 20);
        label.setPreferredSize(dimension);
        label.setSize(dimension);
        label.setFont(GuiHelper.HEADER_FONT);
        return label;
    }

    private void addToPanel(Component comp, int x, int y, int width, int height) {
        comp.setSize(width, height);
        comp.setLocation(x, y);
        this._panel.add(comp);
    }
}

