/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TestRegexDialog
extends BanneredDialog {
    private static final ImageIcon ICON_ERROR = GuiHelper.getImageIcon("images/driver_error.png");
    private static final ImageIcon ICON_SUCCESS = GuiHelper.getImageIcon("images/driver_success.png");
    private static final int NUM_TEST_FIELDS = 10;
    private static final long serialVersionUID = -127974180219204755L;
    private Pattern _pattern;
    private String _expression;
    private List<JTextField> _inputFields;
    private List<JLabel> _statusLabels;
    private JTextField _expressionField;
    private JLabel _errorLabel;

    public TestRegexDialog(String expression) {
        this._expression = expression;
        this._expressionField.setText(this._expression);
        this._pattern = Pattern.compile(expression);
        JTextArea aboutTesting = new JTextArea();
        aboutTesting.setEditable(false);
        aboutTesting.setLineWrap(true);
        aboutTesting.setWrapStyleWord(true);
        aboutTesting.setText("You can test your regular expression by typing input sentences into the fields of this form.");
        this.add((Component)aboutTesting, "South");
    }

    protected Component getContent() {
        JPanel panel = new JPanel();
        JLabel header = new JLabel("Test expression");
        header.setFont(GuiHelper.HEADER_FONT);
        GuiHelper.addToGridBag(header, panel, 0, 0, 2, 1);
        Dimension d = new Dimension(200, 20);
        this._expressionField = new JTextField(this._expression);
        this._expressionField.setPreferredSize(d);
        this._expressionField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                TestRegexDialog.this.checkInputFields();
            }

            public void insertUpdate(DocumentEvent e) {
                TestRegexDialog.this.checkInputFields();
            }

            public void removeUpdate(DocumentEvent e) {
                TestRegexDialog.this.checkInputFields();
            }
        });
        GuiHelper.addToGridBag(this._expressionField, panel, 0, 1);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TestRegexDialog.this._expressionField.setText(TestRegexDialog.this._expression);
            }
        });
        GuiHelper.addToGridBag(resetButton, panel, 1, 1);
        this._errorLabel = new JLabel("");
        GuiHelper.addToGridBag(this._errorLabel, panel, 0, 2);
        header = new JLabel("Test input");
        header.setFont(GuiHelper.HEADER_FONT);
        GuiHelper.addToGridBag(header, panel, 0, 3, 2, 1);
        this._inputFields = new ArrayList<JTextField>(10);
        this._statusLabels = new ArrayList<JLabel>(10);
        for (int i = 0; i < 10; ++i) {
            final int index = i;
            JTextField inputField = new JTextField();
            inputField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    TestRegexDialog.this.checkInputField(index);
                }

                public void insertUpdate(DocumentEvent e) {
                    TestRegexDialog.this.checkInputField(index);
                }

                public void removeUpdate(DocumentEvent e) {
                    TestRegexDialog.this.checkInputField(index);
                }
            });
            inputField.setPreferredSize(d);
            GuiHelper.addToGridBag(inputField, panel, 0, 4 + i);
            JLabel statusLabel = new JLabel();
            GuiHelper.addToGridBag(statusLabel, panel, 1, 4 + i);
            this._inputFields.add(inputField);
            this._statusLabels.add(statusLabel);
        }
        return panel;
    }

    private void checkInputFields() {
        try {
            this._pattern = Pattern.compile(this._expressionField.getText());
            this._errorLabel.setText("");
            for (int i = 0; i < 10; ++i) {
                this.checkInputField(i);
            }
        }
        catch (PatternSyntaxException e) {
            this._errorLabel.setText(e.getMessage());
        }
    }

    private void checkInputField(int index) {
        String text = this._inputFields.get(index).getText();
        JLabel label = this._statusLabels.get(index);
        if ("".equals(text)) {
            label.setIcon(null);
        } else {
            Matcher matcher = this._pattern.matcher(text);
            if (matcher.matches()) {
                label.setIcon(ICON_SUCCESS);
            } else {
                label.setIcon(ICON_ERROR);
            }
        }
    }

    protected String getDialogTitle() {
        return "Test regular expression";
    }
}

