/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.model;

import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSelection
extends Observable
implements Observer {
    private static final Log _log = LogFactory.getLog(ColumnSelection.class);
    private List<Column> _columns = new ArrayList<Column>();

    public ColumnSelection(DataContextSelection dataContextSelection) {
        if (dataContextSelection != null) {
            dataContextSelection.addObserver(this);
        }
    }

    public List<Column> getColumns() {
        return this._columns;
    }

    public void toggleTable(Table table) {
        Column[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (this._columns.contains(columns[i])) {
                this._columns.remove(columns[i]);
                continue;
            }
            this._columns.add(columns[i]);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void toggleColumn(Column column) {
        if (this._columns.contains(column)) {
            this._columns.remove(column);
        } else {
            this._columns.add(column);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void clearSelection() {
        this._columns.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isSelected(Column column) {
        return this._columns.contains(column);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof DataContextSelection) {
            this.clearSelection();
        }
    }

    @Override
    public synchronized void addObserver(Observer o) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("addObserver(" + o + ")"));
        }
        super.addObserver(o);
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("deleteObserver(" + o + ")"));
        }
        super.deleteObserver(o);
    }
}

