/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.ConfigurationPropertiesPanel;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public abstract class AbstractValidatorConfigurationPanel
implements IConfigurationPanel {
    private JPanel _panel = new JPanel();
    protected IValidationRuleDescriptor _descriptor;
    protected ColumnSelection _columnSelection;
    protected ValidationRuleConfiguration _configuration;
    protected ConfigurationPropertiesPanel _propertiesPanel = new ConfigurationPropertiesPanel("Validation rule properties");
    protected JTabbedPane _tabbedPane;
    protected JTextField _nameField;

    public void initialize(JTabbedPane tabbedPane, Object descriptor, ColumnSelection columnSelection, IRunnableConfiguration configuration) {
        this._tabbedPane = tabbedPane;
        this._descriptor = (IValidationRuleDescriptor)descriptor;
        this._columnSelection = columnSelection;
        this._configuration = (ValidationRuleConfiguration)configuration;
    }

    public JPanel getPanel() {
        this._panel.removeAll();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        this.initNameField();
        this._propertiesPanel.updateManagedFields(this._configuration.getValidationRuleProperties());
        GuiHelper.addComponentAligned(this._panel, this._propertiesPanel.getPanel());
        this.createPanel(this._panel, this._configuration);
        return this._panel;
    }

    private void initNameField() {
        this._nameField = this._propertiesPanel.addManagedProperty("Validation rule name");
        this._nameField.setText(this._descriptor.getDisplayName());
        final ActionListener updateNameAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = AbstractValidatorConfigurationPanel.this._nameField.getText().trim();
                if (name.length() > 0) {
                    AbstractValidatorConfigurationPanel.this.updateTabTitle(name);
                }
            }
        };
        this._nameField.addActionListener(updateNameAction);
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                updateNameAction.actionPerformed(null);
            }

            public void keyTyped(KeyEvent e) {
            }
        };
        this._nameField.addKeyListener(keyListener);
    }

    protected abstract void createPanel(JPanel var1, ValidationRuleConfiguration var2);

    public ValidationRuleConfiguration getConfiguration() {
        this._configuration.setValidationRuleProperties(this._propertiesPanel.getProperties());
        this.updateConfiguration();
        return this._configuration;
    }

    public void updateTabTitle(String newTitle) {
        Component[] components = this._tabbedPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getComponent(0);
            }
            if (component != this._panel) continue;
            this._tabbedPane.setTitleAt(i, newTitle);
            break;
        }
    }

    protected abstract void updateConfiguration();
}

