/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.windows.PreviewDataWindow;
import dk.eobjects.metamodel.MetaModelHelper;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class ColumnSelectionPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 7635979788279430168L;
    private DataContextSelection _schemaSelection;
    private ColumnSelection _dataSelection;
    private JTextField _tableField;
    private JTextArea _columnsField;

    public ColumnSelectionPanel(DataContextSelection schemaSelection, ColumnSelection dataSelection) {
        this._dataSelection = dataSelection;
        this._dataSelection.addObserver(this);
        this._schemaSelection = schemaSelection;
        this.setLayout(null);
        JLabel label = new JLabel("Double-click items in the schema tree to add them to the data selection.");
        label.setLocation(110, 10);
        label.setSize(400, 14);
        this.add(label);
        JLabel tableLabel = new JLabel("Table(s):");
        tableLabel.setLocation(10, 35);
        tableLabel.setSize(100, 20);
        this.add(tableLabel);
        this._tableField = new JTextField();
        this._tableField.setEditable(false);
        this._tableField.setLocation(110, 35);
        this._tableField.setBorder(new LineBorder(Color.GRAY, 1));
        this._tableField.setSize(400, 20);
        this.add(this._tableField);
        JLabel columnsLabel = new JLabel("Column(s):");
        columnsLabel.setLocation(10, 60);
        columnsLabel.setSize(100, 20);
        this.add(columnsLabel);
        this._columnsField = new JTextArea();
        this._columnsField.setName("selected_columns");
        this._columnsField.setEditable(false);
        this._columnsField.setWrapStyleWord(true);
        this._columnsField.setLineWrap(true);
        this._columnsField.setColumns(50);
        this._columnsField.setBorder(null);
        JScrollPane scrollPane = new JScrollPane(this._columnsField);
        scrollPane.setSize(400, 120);
        scrollPane.setLocation(110, 60);
        scrollPane.setBorder(new LineBorder(Color.GRAY, 1));
        this.add(scrollPane);
        JButton clearButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -3071644355317918338L;

            public void actionPerformed(ActionEvent e) {
                ColumnSelectionPanel.this._dataSelection.clearSelection();
                ColumnSelectionPanel.this._tableField.setText("");
                ColumnSelectionPanel.this._columnsField.setText("");
            }
        });
        clearButton.setLocation(180, 190);
        clearButton.setSize(170, 28);
        clearButton.setIcon(GuiHelper.getImageIcon("images/toolbar_clear_selection.png"));
        clearButton.setText("Clear selection");
        this.add(clearButton);
        JButton previewButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 399335655615494066L;

            public void actionPerformed(ActionEvent event) {
                ColumnSelectionPanel.this.previewData();
            }
        });
        previewButton.setLocation(360, 190);
        previewButton.setSize(150, 28);
        previewButton.setIcon(GuiHelper.getImageIcon("images/toolbar_preview_data.png"));
        previewButton.setText("Preview data");
        this.add(previewButton);
    }

    private void updateDataFields() {
        int i;
        StringBuilder tableSb = new StringBuilder();
        StringBuilder columnSb = new StringBuilder();
        List<Column> columns = this._dataSelection.getColumns();
        Table[] tables = MetaModelHelper.getTables(columns);
        for (i = 0; i < tables.length; ++i) {
            if (i != 0) {
                tableSb.append(", ");
            }
            tableSb.append(tables[i].getName());
        }
        this._tableField.setText(tableSb.toString());
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                columnSb.append(", ");
            }
            Column column = columns.get(i);
            GuiHelper.getLabelForColumn(column);
            columnSb.append(GuiHelper.getLabelForColumn(column));
        }
        this._columnsField.setText(columnSb.toString());
    }

    public void update(Observable o, Object arg) {
        if (o instanceof ColumnSelection) {
            this.updateDataFields();
        }
    }

    private void previewData() {
        if (this._schemaSelection != null && this._dataSelection.getColumns().size() > 0) {
            int numRecords = 400;
            String userInput = JOptionPane.showInputDialog("Max. number of records?", (Object)numRecords);
            if (userInput != null) {
                Table[] allTables;
                try {
                    numRecords = Integer.parseInt(userInput);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "The provided max. number of records is not a number. Using default: " + numRecords, "Error!", 2);
                }
                List<Column> configuredColumns = this._dataSelection.getColumns();
                for (Table table : allTables = MetaModelHelper.getTables(configuredColumns)) {
                    Column[] tableColumns = MetaModelHelper.getTableColumns((Table)table, configuredColumns);
                    PreviewDataWindow previewFrame = new PreviewDataWindow(table, tableColumns, this._schemaSelection.getDataContext(), numRecords);
                    DataCleanerGui.getMainWindow().addWindow(previewFrame);
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "No data selected. Doubleclick the tree to the left to select data.", "Error!", 2);
        }
    }
}

