/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.widgets.DataCleanerTable;
import dk.eobjects.datacleaner.gui.widgets.RunComparisonButton;
import dk.eobjects.metamodel.schema.Column;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;

public class ComparatorSelectionPanel
extends JPanel
implements Observer {
    private static final Object[] TABLE_HEADERS = new Object[]{"Compare what?", "To what?"};
    private static final long serialVersionUID = 5627810850053499114L;
    private DataContextSelection _leftDataContextSelection;
    private DataContextSelection _rightDataContextSelection;
    private ColumnSelection _leftColumnSelection;
    private ColumnSelection _rightColumnSelection;
    private DataCleanerTable _table;

    public ComparatorSelectionPanel(DataContextSelection leftDataContextSelection, DataContextSelection rightDataContextSelection, ColumnSelection leftColumnSelection, ColumnSelection rightColumnSelection) {
        super(new BorderLayout());
        this._leftDataContextSelection = leftDataContextSelection;
        this._rightDataContextSelection = rightDataContextSelection;
        this._leftColumnSelection = leftColumnSelection;
        this._rightColumnSelection = rightColumnSelection;
        this._leftColumnSelection.addObserver(this);
        this._rightColumnSelection.addObserver(this);
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.add(new JSeparator(1));
        toolbar.add(new RunComparisonButton(this._leftDataContextSelection, this._rightDataContextSelection, this._leftColumnSelection, this._rightColumnSelection));
        this.add((Component)toolbar, "North");
        this._table = new DataCleanerTable();
        this._table.setModel(new DefaultTableModel(TABLE_HEADERS, 15));
        this.add((Component)this._table.toPanel(), "Center");
        JButton clearLeftButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -843458549283401380L;

            public void actionPerformed(ActionEvent e) {
                ComparatorSelectionPanel.this._leftColumnSelection.clearSelection();
            }
        });
        clearLeftButton.setIcon(GuiHelper.getImageIcon("images/toolbar_clear_selection.png"));
        clearLeftButton.setText("Clear left selection");
        JButton clearRightButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -843458549283401380L;

            public void actionPerformed(ActionEvent e) {
                ComparatorSelectionPanel.this._rightColumnSelection.clearSelection();
            }
        });
        clearRightButton.setIcon(GuiHelper.getImageIcon("images/toolbar_clear_selection.png"));
        clearRightButton.setText("Clear right selection");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)clearLeftButton, "West");
        bottomPanel.add((Component)clearRightButton, "East");
        this.add((Component)bottomPanel, "South");
    }

    public void update(Observable o, Object arg0) {
        if (o instanceof ColumnSelection) {
            String columnName;
            int i;
            List<Column> leftColumns = this._leftColumnSelection.getColumns();
            List<Column> rightColumns = this._rightColumnSelection.getColumns();
            DefaultTableModel model = new DefaultTableModel(TABLE_HEADERS, 15);
            for (i = 0; i < leftColumns.size(); ++i) {
                columnName = leftColumns.get(i).getName();
                model.setValueAt(columnName, i, 0);
            }
            for (i = 0; i < rightColumns.size(); ++i) {
                columnName = rightColumns.get(i).getName();
                model.setValueAt(columnName, i, 1);
            }
            this._table.setModel(model);
        }
    }

    public ColumnSelection getLeftDataSelection() {
        return this._leftColumnSelection;
    }

    public ColumnSelection getRightDataSelection() {
        return this._rightColumnSelection;
    }
}

