/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.panels.DefaultProfilerConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.DefaultValidatorConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.profiler.IProfile;
import dk.eobjects.datacleaner.validator.IValidationRule;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPanelManager {
    private Class<? extends IConfigurationPanel> _defaultProfilerPanel = DefaultProfilerConfigurationPanel.class;
    private Class<? extends IConfigurationPanel> _defaultValidatorPanel = DefaultValidatorConfigurationPanel.class;
    private Map<Class<? extends IProfile>, Class<? extends IConfigurationPanel>> _profilerPanels;
    private Map<Class<? extends IValidationRule>, Class<? extends IConfigurationPanel>> _validatorPanels;

    public IConfigurationPanel getPanelForProfile(Class<? extends IProfile> profileClass) {
        Class<? extends IConfigurationPanel> panelClass = this._defaultProfilerPanel;
        if (this._profilerPanels != null && this._profilerPanels.containsKey(profileClass)) {
            panelClass = this._profilerPanels.get(profileClass);
        }
        try {
            IConfigurationPanel configurationPanel = panelClass.newInstance();
            return configurationPanel;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public IConfigurationPanel getPanelForValidationRule(Class<? extends IValidationRule> validationRuleClass) {
        Class<? extends IConfigurationPanel> panelClass = this._defaultValidatorPanel;
        if (this._validatorPanels != null && this._validatorPanels.containsKey(validationRuleClass)) {
            panelClass = this._validatorPanels.get(validationRuleClass);
        }
        try {
            IConfigurationPanel configurationPanel = panelClass.newInstance();
            return configurationPanel;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setDefaultProfilerPanel(Class<? extends IConfigurationPanel> defaultProfilerPanel) {
        this._defaultProfilerPanel = defaultProfilerPanel;
    }

    public void setDefaultValidatorPanel(Class<? extends IConfigurationPanel> defaultValidatorPanel) {
        this._defaultValidatorPanel = defaultValidatorPanel;
    }

    public void setProfilerPanels(Map<Class<? extends IProfile>, Class<? extends IConfigurationPanel>> profilerPanels) {
        this._profilerPanels = profilerPanels;
    }

    public void setValidatorPanels(Map<Class<? extends IValidationRule>, Class<? extends IConfigurationPanel>> validatorPanels) {
        this._validatorPanels = validatorPanels;
    }
}

