/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPropertiesPanel {
    private Map<String, JTextField> _propertyFields = new HashMap<String, JTextField>();
    private JPanel _panel = new JPanel();
    private int _rows = 0;

    public ConfigurationPropertiesPanel() {
        this._panel.setLayout(new GridBagLayout());
    }

    public ConfigurationPropertiesPanel(String title) {
        this();
        this._panel.setBorder(new TitledBorder(title));
    }

    public void addManagedProperties(String[] propertyNames) {
        for (String string : propertyNames) {
            this.addManagedProperty(string);
        }
    }

    protected JTextField addManagedProperty(String propertyName) {
        JTextField textField = this._propertyFields.get(propertyName);
        if (textField == null) {
            textField = new JTextField(30);
            textField.setName("managed_property_" + propertyName);
            this._propertyFields.put(propertyName, textField);
            this.addComponentToPanel(propertyName, textField);
        }
        return textField;
    }

    public void updateManagedFields(Map<String, String> properties) {
        Set<Map.Entry<String, String>> entrySet = properties.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            JTextField textField = this._propertyFields.get(entry.getKey());
            if (textField == null) continue;
            textField.setText(entry.getValue());
        }
    }

    public void addComponentToPanel(String label, Component component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = this._rows++;
        constraints.ipadx = 10;
        constraints.gridx = 0;
        constraints.anchor = 18;
        this._panel.add((Component)new JLabel(label), constraints);
        constraints.gridx = 1;
        this._panel.add(component, constraints);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        Set<Map.Entry<String, JTextField>> entrySet = this._propertyFields.entrySet();
        for (Map.Entry<String, JTextField> entry : entrySet) {
            properties.put(entry.getKey(), entry.getValue().getText());
        }
        return properties;
    }

    public JTextField getFieldForProperty(String propertyName) {
        return this._propertyFields.get(propertyName);
    }

    public JPanel getPanel() {
        return this._panel;
    }
}

