/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.ConfigurationPropertiesPanel;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.SubsetDataSelectionPanel;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.ProfileConfiguration;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DefaultProfilerConfigurationPanel
implements IConfigurationPanel {
    private ConfigurationPropertiesPanel _propertiesPanel = new ConfigurationPropertiesPanel("Profile properties");
    private JPanel _panel = new JPanel();
    private IProfileDescriptor _profileDescriptor;
    private SubsetDataSelectionPanel _subsetDataSelectionPanel;
    private ProfileConfiguration _configuration;

    public void initialize(JTabbedPane tabbedPane, Object descriptor, ColumnSelection columnSelection, IRunnableConfiguration configuration) {
        Column[] columns;
        this._profileDescriptor = (IProfileDescriptor)descriptor;
        this._configuration = (ProfileConfiguration)configuration;
        this._panel.removeAll();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        this._subsetDataSelectionPanel = new SubsetDataSelectionPanel(columnSelection){
            private static final long serialVersionUID = 4878805667739164299L;

            protected boolean isSupported(ColumnType type) {
                return DefaultProfilerConfigurationPanel.this._profileDescriptor.isSupported(type);
            }
        };
        String[] propertyNames = this._profileDescriptor.getPropertyNames();
        if (propertyNames.length > 0) {
            this._propertiesPanel.addManagedProperties(propertyNames);
            this._propertiesPanel.updateManagedFields(this._configuration.getProfileProperties());
            GuiHelper.addComponentAligned(this._panel, this._propertiesPanel.getPanel());
        }
        if ((columns = this._configuration.getColumns()) != null && columns.length > 0) {
            this._subsetDataSelectionPanel.setSelectedColumns(columns);
        }
        GuiHelper.addComponentAligned(this._panel, this._subsetDataSelectionPanel);
    }

    public ProfileConfiguration getConfiguration() {
        ProfileConfiguration configuration = new ProfileConfiguration(this._profileDescriptor);
        configuration.setColumns(this._subsetDataSelectionPanel.getSelectedColumns());
        configuration.setProfileProperties(this._propertiesPanel.getProperties());
        return configuration;
    }

    public JPanel getPanel() {
        return this._panel;
    }

    public void destroy() throws Exception {
        this._subsetDataSelectionPanel.close();
    }
}

