/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.SubsetDataSelectionPanel;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.ProfileConfiguration;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import dk.eobjects.datacleaner.validator.dictionary.DictionaryManager;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class DictionaryProfileConfigurationPanel
implements IConfigurationPanel {
    private JPanel _panel = new JPanel();
    private IProfileDescriptor _profileDescriptor;
    private SubsetDataSelectionPanel _subsetDataSelectionPanel;
    private ProfileConfiguration _configuration;
    private Map<IDictionary, JCheckBox> _dictionaryCheckBoxes = new HashMap<IDictionary, JCheckBox>();

    public void initialize(JTabbedPane tabbedPane, Object descriptor, ColumnSelection columnSelection, IRunnableConfiguration configuration) {
        IDictionary[] dictionaries;
        this._profileDescriptor = (IProfileDescriptor)descriptor;
        this._configuration = (ProfileConfiguration)configuration;
        this._panel.removeAll();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        this._subsetDataSelectionPanel = new SubsetDataSelectionPanel(columnSelection){
            private static final long serialVersionUID = 4878805667739164299L;

            protected boolean isSupported(ColumnType type) {
                return DictionaryProfileConfigurationPanel.this._profileDescriptor.isSupported(type);
            }
        };
        JPanel dictionaryPanel = new JPanel();
        dictionaryPanel.setLayout(new BoxLayout(dictionaryPanel, 1));
        dictionaryPanel.setBorder(new TitledBorder("Use dictionaries"));
        ArrayList enabledDictionaryNames = ReflectionHelper.getIteratedProperties((String)"dictionary_", (Map)this._configuration.getProfileProperties());
        if (enabledDictionaryNames == null) {
            enabledDictionaryNames = new ArrayList();
        }
        for (IDictionary dictionary : dictionaries = DictionaryManager.getDictionaries()) {
            String dictionaryName = dictionary.getName();
            JCheckBox checkBox = new JCheckBox(dictionaryName);
            if (enabledDictionaryNames.contains(dictionaryName)) {
                checkBox.setSelected(true);
            }
            this._dictionaryCheckBoxes.put(dictionary, checkBox);
            dictionaryPanel.add(checkBox);
        }
        GuiHelper.addComponentAligned(this._panel, dictionaryPanel);
        Column[] columns = this._configuration.getColumns();
        if (columns != null && columns.length > 0) {
            this._subsetDataSelectionPanel.setSelectedColumns(columns);
        }
        GuiHelper.addComponentAligned(this._panel, this._subsetDataSelectionPanel);
    }

    public JPanel getPanel() {
        return this._panel;
    }

    public IRunnableConfiguration getConfiguration() {
        ProfileConfiguration configuration = new ProfileConfiguration(this._profileDescriptor);
        configuration.setColumns(this._subsetDataSelectionPanel.getSelectedColumns());
        HashMap properties = configuration.getProfileProperties();
        if (properties == null) {
            properties = new HashMap();
        }
        ArrayList<String> dictionaryNames = new ArrayList<String>();
        for (Map.Entry<IDictionary, JCheckBox> entry : this._dictionaryCheckBoxes.entrySet()) {
            JCheckBox checkBox = entry.getValue();
            if (!checkBox.isSelected()) continue;
            IDictionary dictionary = entry.getKey();
            dictionaryNames.add(dictionary.getName());
        }
        ReflectionHelper.addIteratedProperties(properties, (String)"dictionary_", (String[])dictionaryNames.toArray(new String[dictionaryNames.size()]));
        configuration.setProfileProperties(properties);
        return configuration;
    }

    public void destroy() throws Exception {
        this._subsetDataSelectionPanel.close();
    }
}

