/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.panels.AbstractValidatorConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.SubsetDataSelectionPanel;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.datacleaner.validator.dictionary.DictionaryManager;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DictionaryValidationRuleConfigurationPanel
extends AbstractValidatorConfigurationPanel {
    private JComboBox _dictionaryDropDown = new JComboBox();
    private SubsetDataSelectionPanel _subsetDataSelectionPanel;

    protected void createPanel(JPanel panel, ValidationRuleConfiguration configuration) {
        Column[] columns;
        this.createDictionaryDropDown();
        this._dictionaryDropDown.setName("dictionaryDropDown");
        this._propertiesPanel.addComponentToPanel("Dictionary", this._dictionaryDropDown);
        this._subsetDataSelectionPanel = new SubsetDataSelectionPanel(this._columnSelection){
            private static final long serialVersionUID = -5227491742509256691L;

            protected boolean isSupported(ColumnType type) {
                return DictionaryValidationRuleConfigurationPanel.this._descriptor.isSupported(type);
            }
        };
        String dictionaryName = (String)configuration.getValidationRuleProperties().get("Dictionary name");
        if (dictionaryName != null) {
            this._dictionaryDropDown.setSelectedItem(dictionaryName);
        }
        if ((columns = configuration.getColumns()) != null && columns.length > 0) {
            this._subsetDataSelectionPanel.setSelectedColumns(columns);
        }
        GuiHelper.addComponentAligned(panel, this._subsetDataSelectionPanel);
    }

    protected void updateConfiguration() {
        List<Column> columns = this._subsetDataSelectionPanel.getSelectedColumns();
        this._configuration.setColumns(columns);
        Object selectedItem = this._dictionaryDropDown.getSelectedItem();
        Map properties = this._configuration.getValidationRuleProperties();
        if (selectedItem != null) {
            properties.put("Dictionary name", selectedItem.toString());
        }
    }

    public void destroy() throws Exception {
        this._subsetDataSelectionPanel.close();
    }

    private void createDictionaryDropDown() {
        IDictionary[] dictionaries = DictionaryManager.getDictionaries();
        for (int i = 0; i < dictionaries.length; ++i) {
            IDictionary d = dictionaries[i];
            String dictionaryName = d.getName();
            if (dictionaryName == null) continue;
            this._dictionaryDropDown.addItem(dictionaryName);
        }
    }

    public JComboBox getDictionaryDropDown() {
        return this._dictionaryDropDown;
    }
}

