/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.panels.AbstractValidatorConfigurationPanel;
import dk.eobjects.datacleaner.gui.widgets.TableDataSelectionComboBox;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.metamodel.MetaModelHelper;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import dk.eobjects.thirdparty.textarea.DefaultInputHandler;
import dk.eobjects.thirdparty.textarea.JEditTextArea;
import dk.eobjects.thirdparty.textarea.tokermarkers.JavaScriptTokenMarker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class JavascriptValidationRuleConfigurationPanel
extends AbstractValidatorConfigurationPanel {
    private static final String EXAMPLE_SCRIPT_PREFIX = "var value = values.get('";
    private static final String EXAMPLE_SCRIPT_SUFFIX = "');\nvalue != null && value != '';";
    private boolean _updateScriptOnColumnSelectionChange = true;
    private JEditTextArea _expressionTextArea;
    private TableDataSelectionComboBox _tableComboBox;

    protected void createPanel(JPanel panel, ValidationRuleConfiguration configuration) {
        Table table;
        this._tableComboBox = new TableDataSelectionComboBox(this._columnSelection);
        this._tableComboBox.setName("tableComboBox");
        this._tableComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavascriptValidationRuleConfigurationPanel.this.updateScript();
            }
        });
        this._propertiesPanel.addComponentToPanel("Table", this._tableComboBox);
        JPanel expressionPanel = new JPanel(new BorderLayout());
        expressionPanel.setBorder(new TitledBorder("Expression"));
        this._expressionTextArea = new JEditTextArea();
        this._expressionTextArea.setTokenMarker(new JavaScriptTokenMarker());
        DefaultInputHandler inputHandler = new DefaultInputHandler(){

            public void keyTyped(KeyEvent evt) {
                JavascriptValidationRuleConfigurationPanel.this._updateScriptOnColumnSelectionChange = false;
                super.keyTyped(evt);
            }
        };
        inputHandler.addDefaultKeyBindings();
        this._expressionTextArea.setInputHandler(inputHandler);
        Column[] columns = configuration.getColumns();
        if (columns != null && columns.length > 0 && (table = columns[0].getTable()) != null) {
            this._tableComboBox.setSelectedTable(table);
        }
        this.updateScript();
        this._expressionTextArea.setBorder(new LineBorder(Color.GRAY));
        expressionPanel.add((Component)this._expressionTextArea, "Center");
        GuiHelper.addComponentAligned(panel, expressionPanel);
    }

    protected void updateConfiguration() {
        Map properties = this._configuration.getValidationRuleProperties();
        properties.put("Javascript expression", this._expressionTextArea.getText());
        Table selectedTable = this._tableComboBox.getSelectedTable();
        if (selectedTable != null) {
            Column[] tableColumns = MetaModelHelper.getTableColumns((Table)selectedTable, this._columnSelection.getColumns());
            this._configuration.setColumns(tableColumns);
        }
    }

    public void destroy() throws Exception {
        this._tableComboBox.close();
    }

    public JEditTextArea getExpressionTextArea() {
        return this._expressionTextArea;
    }

    public TableDataSelectionComboBox getTableComboBox() {
        return this._tableComboBox;
    }

    private void updateScript() {
        if (this._updateScriptOnColumnSelectionChange) {
            String expression = (String)this._configuration.getValidationRuleProperties().get("Javascript expression");
            if (expression == null) {
                String columnName = "COLUMN_NAME";
                List<Column> columns = this._columnSelection.getColumns();
                if (columns.size() > 0) {
                    Table table = this._tableComboBox.getSelectedTable();
                    for (Column column : columns) {
                        if (table != column.getTable()) continue;
                        columnName = column.getName();
                        break;
                    }
                }
                this._expressionTextArea.setText(EXAMPLE_SCRIPT_PREFIX + columnName + EXAMPLE_SCRIPT_SUFFIX);
                this._expressionTextArea.setSelectionStart(EXAMPLE_SCRIPT_PREFIX.length());
                this._expressionTextArea.setSelectionEnd((EXAMPLE_SCRIPT_PREFIX + columnName).length());
            } else {
                this._expressionTextArea.setText(expression);
                this._updateScriptOnColumnSelectionChange = false;
            }
        }
    }
}

