/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.widgets.DataCleanerTable;
import dk.eobjects.metamodel.schema.Column;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

public class MetadataPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = -8700916792678228132L;
    public static final int COLUMN_TABLE = 0;
    public static final int COLUMN_COLUMN = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_NATIVE_TYPE = 3;
    public static final int COLUMN_SIZE = 4;
    public static final int COLUMN_NULLABLE = 5;
    public static final int COLUMN_INDEXED = 6;
    public static final int COLUMN_REMARKS = 7;
    private DataCleanerTable _table;

    public MetadataPanel(ColumnSelection dataSelection) {
        this.setLayout(new BorderLayout());
        dataSelection.addObserver(this);
        this.updatePanel(dataSelection);
    }

    private void updatePanel(ColumnSelection dataSelection) {
        List<Column> columns = dataSelection.getColumns();
        int rowCount = columns.size();
        int columnCount = 7;
        DefaultTableModel tableModel = new DefaultTableModel(rowCount, columnCount);
        tableModel.setColumnIdentifiers(new String[]{"Table", "Column", "Type", "Native type", "Size", "Nullable", "Indexed?", "Remarks"});
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            tableModel.setValueAt(column.getTable().getName(), i, 0);
            tableModel.setValueAt(column.getName(), i, 1);
            tableModel.setValueAt(column.getType(), i, 2);
            tableModel.setValueAt(column.getNativeType(), i, 3);
            tableModel.setValueAt(column.getColumnSize(), i, 4);
            tableModel.setValueAt(column.isNullable(), i, 5);
            tableModel.setValueAt(column.isIndexed(), i, 6);
            tableModel.setValueAt(column.getRemarks(), i, 7);
        }
        this._table = new DataCleanerTable();
        this._table.setModel(tableModel);
        this._table.addHighlighter(GuiHelper.LIBERELLO_HIGHLIGHTER);
        this.removeAll();
        this.add((Component)this._table.getTableHeader(), "North");
        this.add((Component)((Object)this._table), "Center");
    }

    public void update(Observable o, Object arg1) {
        if (o instanceof ColumnSelection) {
            this.updatePanel((ColumnSelection)o);
        }
    }

    public DataCleanerTable getTable() {
        return this._table;
    }
}

