/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.catalog.NamedRegex;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.TestRegexDialog;
import dk.eobjects.datacleaner.gui.panels.AbstractValidatorConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.SubsetDataSelectionPanel;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RegexValidationRuleConfigurationPanel
extends AbstractValidatorConfigurationPanel {
    private SubsetDataSelectionPanel _subsetDataSelectionPanel;
    private JTextField _expressionField;
    private JButton _testButton;

    protected void createPanel(JPanel panel, ValidationRuleConfiguration configuration) {
        JPanel expressionPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._expressionField = new JTextField(30);
        this._expressionField.setName("expressionField");
        expressionPanel.add(this._expressionField);
        String expression = (String)configuration.getValidationRuleProperties().get("Regular expression");
        if (expression != null) {
            this._expressionField.setText(expression);
        }
        this._testButton = new JButton("Test it");
        this._testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestRegexDialog dialog = new TestRegexDialog(RegexValidationRuleConfigurationPanel.this._expressionField.getText());
                dialog.setVisible(true);
            }
        });
        expressionPanel.add(this._testButton);
        this._propertiesPanel.addComponentToPanel("Expression", expressionPanel);
        final List<NamedRegex> regexes = GuiSettings.getSettings().getRegexes();
        Object[] items = ReflectionHelper.getProperties(regexes, (String)"name");
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(items));
        list.add(0, "-");
        final JComboBox<Object> regexCatalogDropdown = new JComboBox<Object>(list.toArray());
        regexCatalogDropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = regexCatalogDropdown.getSelectedIndex();
                if (index == 0) {
                    RegexValidationRuleConfigurationPanel.this._expressionField.setText("");
                } else {
                    NamedRegex regex = (NamedRegex)regexes.get(index - 1);
                    RegexValidationRuleConfigurationPanel.this._expressionField.setText(regex.getExpression());
                }
            }
        });
        this._propertiesPanel.addComponentToPanel("Select from catalog...", regexCatalogDropdown);
        this._subsetDataSelectionPanel = new SubsetDataSelectionPanel(this._columnSelection){
            private static final long serialVersionUID = -5227491742509256691L;

            protected boolean isSupported(ColumnType type) {
                return RegexValidationRuleConfigurationPanel.this._descriptor.isSupported(type);
            }
        };
        Column[] columns = configuration.getColumns();
        if (columns != null && columns.length > 0) {
            this._subsetDataSelectionPanel.setSelectedColumns(columns);
        }
        GuiHelper.addComponentAligned(panel, this._subsetDataSelectionPanel);
    }

    protected void updateConfiguration() {
        List<Column> columns = this._subsetDataSelectionPanel.getSelectedColumns();
        this._configuration.setColumns(columns);
        Map properties = this._configuration.getValidationRuleProperties();
        properties.put("Regular expression", this._expressionField.getText());
    }

    public void destroy() throws Exception {
        this._subsetDataSelectionPanel.close();
    }
}

