/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubsetDataSelectionPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 3797363932708302358L;
    private static final Log _log = LogFactory.getLog(SubsetDataSelectionPanel.class);
    private ColumnSelection _dataSelection;
    private JRadioButton _allDataRadio;
    private JRadioButton _subsetRadio;
    private JPanel _subsetPanel;
    private Map<Column, JCheckBox> _subsetCheckBoxes = new HashMap<Column, JCheckBox>();

    public SubsetDataSelectionPanel(ColumnSelection columnSelection) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder("Apply to"));
        this._dataSelection = columnSelection;
        this._dataSelection.addObserver(this);
        this._allDataRadio = new JRadioButton("All selected data.", true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._allDataRadio);
        this.add(this._allDataRadio);
        this._subsetRadio = new JRadioButton("Subset of data:");
        buttonGroup.add(this._subsetRadio);
        this.add(this._subsetRadio);
        this._subsetPanel = new JPanel();
        this._subsetPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        this._subsetPanel.setLayout(new BoxLayout(this._subsetPanel, 1));
        this.add(this._subsetPanel);
        this.updateProfileDataPanel();
    }

    private void updateProfileDataPanel() {
        this._allDataRadio.setSelected(true);
        this._allDataRadio.setEnabled(true);
        this._subsetPanel.removeAll();
        this._subsetCheckBoxes.clear();
        List<Column> columns = this._dataSelection.getColumns();
        for (Column column : columns) {
            boolean enabled = this.isSupported(column.getType());
            this._subsetPanel.add(this.createCheckBox(column, enabled));
            if (enabled) continue;
            this._allDataRadio.setEnabled(false);
            this._allDataRadio.setSelected(false);
            this._subsetRadio.setSelected(true);
        }
        if (!this._allDataRadio.isEnabled()) {
            Set<Map.Entry<Column, JCheckBox>> entrySet = this._subsetCheckBoxes.entrySet();
            for (Map.Entry<Column, JCheckBox> entry : entrySet) {
                JCheckBox checkBox = entry.getValue();
                if (!checkBox.isEnabled()) continue;
                checkBox.setSelected(true);
            }
        }
    }

    protected abstract boolean isSupported(ColumnType var1);

    private Component createCheckBox(Column column, boolean enabled) {
        final JCheckBox checkBox = new JCheckBox(GuiHelper.getLabelForColumn(column), false);
        checkBox.setEnabled(enabled);
        checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (checkBox.isSelected()) {
                    SubsetDataSelectionPanel.this._subsetRadio.setSelected(true);
                }
            }
        });
        this._subsetCheckBoxes.put(column, checkBox);
        return checkBox;
    }

    public List<Column> getSelectedColumns() {
        if (this._subsetRadio.isSelected()) {
            ArrayList<Column> columns = new ArrayList<Column>();
            Set<Map.Entry<Column, JCheckBox>> entrySet = this._subsetCheckBoxes.entrySet();
            for (Map.Entry<Column, JCheckBox> entry : entrySet) {
                JCheckBox checkBox = entry.getValue();
                if (!checkBox.isSelected()) continue;
                columns.add(entry.getKey());
            }
            return columns;
        }
        return this._dataSelection.getColumns();
    }

    @Override
    public void update(Observable o, Object arg1) {
        if (o instanceof ColumnSelection) {
            this.updateProfileDataPanel();
        }
    }

    public JRadioButton getAllDataRadio() {
        return this._allDataRadio;
    }

    public JRadioButton getSubsetRadio() {
        return this._subsetRadio;
    }

    public Map<Column, JCheckBox> getSubsetCheckBoxes() {
        return this._subsetCheckBoxes;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        _log.debug((Object)"Closing subset data selection panel");
        this._dataSelection.deleteObserver(this);
        this._subsetCheckBoxes = null;
    }

    public void setSelectedColumns(Column[] columns) {
        this._allDataRadio.setSelected(false);
        this._subsetRadio.setSelected(true);
        Set<Map.Entry<Column, JCheckBox>> entrySet = this._subsetCheckBoxes.entrySet();
        for (Map.Entry<Column, JCheckBox> entry : entrySet) {
            Column column = entry.getKey();
            JCheckBox checkBox = entry.getValue();
            if (ArrayUtils.indexOf((Object[])columns, (Object)column) != -1) {
                checkBox.setSelected(true);
                continue;
            }
            checkBox.setSelected(false);
        }
    }
}

