/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.panels;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.widgets.ColumnHighlighter;
import dk.eobjects.datacleaner.gui.widgets.DataTable;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.IValidationRuleResult;
import dk.eobjects.datacleaner.validator.trivial.DummyValidationRule;
import dk.eobjects.metamodel.data.DataSet;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.ArrayUtils;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableValidationRuleResultsPanel
extends JPanel {
    private static final long serialVersionUID = 78962947201100801L;
    public static final Icon ICON_FAILED = GuiHelper.getImageIcon("images/validation_failed.png");
    public static final Icon ICON_SUCCESS = GuiHelper.getImageIcon("images/validation_success.png");
    public static final Icon ICON_ERROR = GuiHelper.getImageIcon("images/validation_error.png");

    public TableValidationRuleResultsPanel(Table table, Column[] queriedColumns, List<IValidationRuleResult> results) {
        this.setLayout(new BorderLayout());
        JXTaskPaneContainer taskPaneContainer = new JXTaskPaneContainer();
        JLabel label = new JLabel("Validation results for " + table.getName());
        label.setFont(GuiHelper.HEADER_FONT);
        taskPaneContainer.add((Component)label);
        for (IValidationRuleResult result : results) {
            String validationRuleName;
            if (result.getDescriptor() == DummyValidationRule.DESCRIPTOR) continue;
            JXTaskPane taskPane = new JXTaskPane();
            taskPane.setAnimated(false);
            String title = "Unnamed validation rule";
            IValidationRuleDescriptor descriptor = result.getDescriptor();
            taskPane.add((Component)new JLabel("Type: " + descriptor.getDisplayName(), GuiHelper.getImageIcon(descriptor.getIconPath()), 2));
            Map resultProperties = result.getProperties();
            if (resultProperties != null && (validationRuleName = (String)resultProperties.get("Validation rule name")) != null) {
                title = validationRuleName;
            }
            taskPane.setTitle(title);
            if (result.isValidated()) {
                taskPane.setIcon(ICON_SUCCESS);
                taskPane.setExpanded(false);
                taskPane.add((Component)new JLabel("All rows where validated."));
            } else {
                Exception error = result.getError();
                taskPane.setExpanded(true);
                if (error != null) {
                    taskPane.setIcon(ICON_ERROR);
                    JLabel errorLabel = new JLabel(error.getMessage());
                    errorLabel.setFont(errorLabel.getFont().deriveFont(1));
                    taskPane.add((Component)errorLabel);
                    taskPane.add((Component)new JLabel("See the log for details."));
                } else {
                    taskPane.setIcon(ICON_FAILED);
                    taskPane.add((Component)new JLabel(result.getUnvalidatedRows().size() + " rows did not validate"));
                    JPanel errorRowsTablePanel = new JPanel(new BorderLayout());
                    List rows = result.getUnvalidatedRows();
                    DataSet data = new DataSet(rows);
                    DataTable dataTable = new DataTable(data);
                    Column[] evaluatedColumns = result.getEvaluatedColumns();
                    int[] evaluatedColumnIndexes = new int[evaluatedColumns.length];
                    for (int i = 0; i < evaluatedColumnIndexes.length; ++i) {
                        evaluatedColumnIndexes[i] = ArrayUtils.indexOf((Object[])queriedColumns, (Object)evaluatedColumns[i]);
                    }
                    dataTable.addHighlighter(new ColumnHighlighter(evaluatedColumnIndexes));
                    errorRowsTablePanel.add((Component)dataTable.getTableHeader(), "North");
                    errorRowsTablePanel.add((Component)((Object)dataTable), "Center");
                    taskPane.add((Component)errorRowsTablePanel);
                }
            }
            taskPaneContainer.add(taskPane);
        }
        this.add((Component)taskPaneContainer, "Center");
    }
}

