/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.setup;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.catalog.NamedRegex;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.DatabaseDriver;
import dk.eobjects.datacleaner.validator.dictionary.DictionaryManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiSettings
extends Observable
implements Serializable {
    public static final String SETTINGS_FILE = "datacleaner-settings.data";
    public static final String REGEXES_FILE = "datacleaner-regexes.properties";
    private static final long serialVersionUID = -8625459660466339757L;
    private static final Log _log = LogFactory.getLog(GuiSettings.class);
    private static GuiSettings _cachedSettings;
    private List<IDictionary> _dictionaries = new ArrayList<IDictionary>();
    private List<DatabaseDriver> _databaseDrivers = new ArrayList<DatabaseDriver>();
    private String _lookAndFeelClassName;
    private boolean _horisontalMatrixTables = true;
    private transient List<NamedRegex> _regexes = new ArrayList<NamedRegex>();

    public static void initialize() {
        GuiSettings settings = GuiSettings.getSettings();
        PlasticXPLookAndFeel plasticXPLookAndFeel = new PlasticXPLookAndFeel();
        GuiSettings.installLookAndFeel((LookAndFeel)plasticXPLookAndFeel);
        Plastic3DLookAndFeel plastic3DLookAndFeel = new Plastic3DLookAndFeel();
        GuiSettings.installLookAndFeel((LookAndFeel)plastic3DLookAndFeel);
        PlasticLookAndFeel plasticLookAndFeel = new PlasticLookAndFeel();
        GuiSettings.installLookAndFeel((LookAndFeel)plasticLookAndFeel);
        WindowsLookAndFeel windowsLookAndFeel = new WindowsLookAndFeel();
        String settingsLookAndFeel = settings.getLookAndFeelClassName();
        if (settingsLookAndFeel != null) {
            try {
                UIManager.setLookAndFeel(settingsLookAndFeel);
            }
            catch (Exception e) {
                _log.error((Object)e);
            }
        } else {
            try {
                if (windowsLookAndFeel.isSupportedLookAndFeel()) {
                    GuiSettings.installLookAndFeel((LookAndFeel)windowsLookAndFeel);
                    UIManager.setLookAndFeel((LookAndFeel)windowsLookAndFeel);
                } else {
                    UIManager.setLookAndFeel((LookAndFeel)plastic3DLookAndFeel);
                }
            }
            catch (UnsupportedLookAndFeelException e) {
                _log.error((Object)e);
            }
        }
        settings.setLookAndFeelClassName(UIManager.getLookAndFeel().getClass().getName());
        DictionaryManager.setDictionaries(settings.getDictionaries());
    }

    private static void installLookAndFeel(LookAndFeel lookAndFeel) {
        String lookAndFeelClass = lookAndFeel.getClass().getCanonicalName();
        UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < installedLookAndFeels.length; ++i) {
            if (!installedLookAndFeels[i].getClassName().equals(lookAndFeelClass)) continue;
            return;
        }
        UIManager.installLookAndFeel(lookAndFeel.getName(), lookAndFeelClass);
    }

    public static void saveSettings(GuiSettings settings) {
        try {
            if (settings != null) {
                ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(new File(SETTINGS_FILE)));
                outputStream.writeObject(settings);
                outputStream.close();
                List<NamedRegex> regexes = settings.getRegexes();
                NamedRegex.saveToFile(regexes, (File)new File(REGEXES_FILE));
                _cachedSettings = settings;
                settings.setChanged();
                settings.notifyObservers();
            }
        }
        catch (Exception e) {
            _log.error((Object)e);
            GuiHelper.showErrorMessage("Error saving settings", e.getMessage(), e);
        }
    }

    public static GuiSettings getSettings() {
        if (_cachedSettings == null) {
            File settingsFile = new File(SETTINGS_FILE);
            File regexesFile = new File(REGEXES_FILE);
            if (settingsFile.exists()) {
                try {
                    ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(settingsFile));
                    _cachedSettings = (GuiSettings)inputStream.readObject();
                    inputStream.close();
                }
                catch (Exception e) {
                    GuiHelper.showErrorMessage("Error loading settings", e.getMessage(), e);
                }
            } else {
                _cachedSettings = new GuiSettings();
            }
            if (regexesFile.exists()) {
                _cachedSettings.setRegexes(NamedRegex.loadFromFile((File)regexesFile));
            } else {
                _log.warn((Object)"Regex file does not exist: datacleaner-regexes.properties");
                _cachedSettings.setRegexes(new ArrayList<NamedRegex>());
            }
        }
        return _cachedSettings;
    }

    public boolean isHorisontalMatrixTables() {
        return this._horisontalMatrixTables;
    }

    public void setHorisontalMatrixTables(boolean horisontalMatrixTables) {
        this._horisontalMatrixTables = horisontalMatrixTables;
    }

    public String getLookAndFeelClassName() {
        return this._lookAndFeelClassName;
    }

    public GuiSettings setLookAndFeelClassName(String lookAndFeelClassName) {
        this._lookAndFeelClassName = lookAndFeelClassName;
        return this;
    }

    public List<IDictionary> getDictionaries() {
        return this._dictionaries;
    }

    public GuiSettings setDictionaries(List<IDictionary> dictionaries) {
        this._dictionaries = dictionaries;
        return this;
    }

    public List<NamedRegex> getRegexes() {
        return this._regexes;
    }

    public GuiSettings setRegexes(List<NamedRegex> regexes) {
        this._regexes = regexes;
        return this;
    }

    public String toString() {
        return "GuiSettings[lookAndFeelClassName=" + this._lookAndFeelClassName + ",dictionaries=" + ArrayUtils.toString((Object)this._dictionaries.toArray()) + ",databaseDrivers=" + ArrayUtils.toString((Object)this._databaseDrivers.toArray()) + ",regexes=" + ArrayUtils.toString((Object)this._regexes.toArray()) + "]";
    }

    public List<DatabaseDriver> getDatabaseDrivers() {
        return this._databaseDrivers;
    }

    public GuiSettings setDatabaseDrivers(List<DatabaseDriver> driverLocations) {
        this._databaseDrivers = driverLocations;
        return this;
    }
}

