/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.ConfigurationPanelManager;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.ProfileConfiguration;
import dk.eobjects.datacleaner.profiler.ProfileManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddProfileButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = -3189155332753633377L;
    private ColumnSelection _columnSelection;
    private JTabbedPane _tabbedPane;
    private Map<JPanel, IConfigurationPanel> _configurationPanels;
    private ConfigurationPanelManager _configurationPanelManager = GuiConfiguration.getConfigurationPanelManager();

    public AddProfileButton(ColumnSelection columnSelection, JTabbedPane tabbedPane, Map<JPanel, IConfigurationPanel> panels) {
        super("Add profile", GuiHelper.getImageIcon("images/toolbar_add.png"));
        this._columnSelection = columnSelection;
        this._tabbedPane = tabbedPane;
        this._configurationPanels = panels;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IProfileDescriptor[] profileDescriptors;
        JPopupMenu popup = new JPopupMenu("Profiles");
        for (IProfileDescriptor profileDescriptor : profileDescriptors = ProfileManager.getProfileDescriptors()) {
            JMenuItem item = this.createProfileItem(profileDescriptor);
            popup.add(item);
        }
        popup.show(this, 0, this.getHeight());
    }

    private JMenuItem createProfileItem(final IProfileDescriptor pd) {
        final ImageIcon icon = GuiHelper.getImageIcon(pd.getIconPath());
        final String displayName = pd.getDisplayName();
        JMenuItem item = new JMenuItem(displayName, icon);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IConfigurationPanel configurationPanel = AddProfileButton.this._configurationPanelManager.getPanelForProfile(pd.getProfileClass());
                configurationPanel.initialize(AddProfileButton.this._tabbedPane, pd, AddProfileButton.this._columnSelection, (IRunnableConfiguration)new ProfileConfiguration(pd));
                JPanel panel = configurationPanel.getPanel();
                AddProfileButton.this._configurationPanels.put(panel, configurationPanel);
                AddProfileButton.this._tabbedPane.addTab(displayName, icon, new JScrollPane(panel));
            }
        });
        return item;
    }
}

